measure_names={'Hellinger distance','Euclidean distance','Cosine distance',...
    'Kolmogorov distance','JS divergence'};

v1=[-1 1 1]'; v2=[1 -1 1]'; v3=[1 1 -1]'; o=[1 1 1]';
C1=v1*v1'; C2=v2*v2'; C3=v3*v3'; J=o*o';

[xi,yi] = meshgrid(linspace(0,2,60),linspace(0,1,60));
alpha=cat(1,yi(:)',.5*xi(:)'-.5*yi(:)',1-(xi(:)'+yi(:)')/2);


dist=nan(numel(xi),numel(measure_names));
A=[0 0 0.5 0.5]'; %target

for ii=1:numel(xi)
    if all(alpha(:,ii)>0)
        X=[alpha(:,ii);0];
        % Hellinger
        A12=sqrt(A);
        X12=sqrt(X);
        bcoef=min(1,A12'*X12);
        dist(ii,1)=sqrt(2-2*bcoef);
        % Euclidean
        dist(ii,2)=sqrt(sum((X-A).^2));
        % Cosine
        X_l2=X/norm(X);
        A_l2=A/norm(A);
        dist(ii,3)=norm(X_l2-A_l2,'fro');%normalized euclidean is cosine
        % Kolmogorov
        dist(ii,4)=1/2*sum(abs(X-A));
        % Jensen-Shannon divergence
        h=@(x) sum(-x.*log2(x+(x==0))); 
        dist(ii,5)=h((X+A)/2)-(h(X)+h(A))/2;
    end
end
%%
print_bold=@(x,y,v) text(x,y,v,'fontweight','bold','fontname','Times New Roman');
print_small=@(x,y,v) text(x,y,v,'fontsize',8,'fontname','Times New Roman');
lil=.07;
print_pretty_c=@(x) [print_bold(-.07,-.09,'\beta');print_bold(1,-.09,'\beta');print_bold(.45,1.1,'\beta');
    print_small(-.07+lil,-.07-lil,'3');print_small(1+lil,-.07-lil,'2');print_small(.45+lil,1.1-lil,'1');];

figure(3),clf
set(gcf,'position',get(gcf,'position').*[1 1 0  0]+[   0 0 1000   300]);

for ii=1:numel(measure_names)
    subplot(1,5,ii)

    plot([0 1 .5 0]',[0 0 1 0]','-k','linewidth',1)
    hold all
    
    contour(xi/2,yi,reshape(dist(:,ii),size(xi)),'linewidth',2)
    
    [min_dist,~]=min(dist(:,ii));
    min_idx=abs(dist(:,ii)-min_dist)<=1e-9;
    
    set(gca,'ytick',[],'xtick',[])
    axis square
    print_pretty_c(0);
    set(gca,'ytick',[],'xtick',[],'box','off','visible','off')
    color = get(gcf,'Color');
    set(gca,'XColor',color,'YColor',color);
    text(.5,1.3,measure_names{ii},'hor','center','fontsize',12,'Interpreter','latex')
    colorbar
end

set(gcf,'paperpositionmode','auto')
saveas(gcf,'../results/Figure_3_demo_simplex_distances.eps','epsc2')
