measure_names={'Bures distance','Euclidean distance','Cosine distance','HSIC dissimlarity','CKA dissimilarity',...
    'Trace distance','QJS divergence','Chernoff distance','QH distance','Sub-Bures dissimilarity'};


v1=[-1 1 1]'; v2=[1 -1 1]'; v3=[1 1 -1]'; o=[1 1 1]';
C1=v1*v1'; C2=v2*v2'; C3=v3*v3'; J=o*o';
[xi,yi] = meshgrid(linspace(0,2,60),linspace(0,1,60));
alpha=cat(1,yi(:)',.5*xi(:)'-.5*yi(:)',1-(xi(:)'+yi(:)')/2);



dist=nan(numel(xi),numel(measure_names));
dhand=nan(numel(xi),2);


A=(blkdiag(ones(2),1))/3; % target matrix
A12=safe_sqrtm(A); % square root of target matrix
for ii=1:numel(xi)
    if all(alpha(:,ii)>0)
    X=(alpha(1,ii)*C1+alpha(2,ii)*C2+alpha(3,ii)*C3)/3;
    % Bures distance
    dist(ii,1)=bures_metric(X,A);        
    % Euclidean distance
    dist(ii,2)=norm(X-A,'fro');%euclidean         
    % Cosine distance
    X_l2=X/norm(X,'fro');
    A_l2=A/norm(A,'fro');
    dist(ii,3)=norm(X_l2-A_l2,'fro');%normalized euclidean is cosine         
    % Hilbert-Schmidt Independence Criterion
    H=eye(3)-1/3; % centering matrix
    Xc=H*X*H;
    Ac=H*A*H;
    dist(ii,4)=norm(Xc-Ac,'fro');%HSIC distance         
    % Centered kernel alignment
    Xc_l2=Xc/norm(Xc,'fro');
    Ac_l2=Ac/norm(Ac,'fro');
    dist(ii,5)=norm(Xc_l2-Ac_l2,'fro');%CKA
    % Trace distance
    dist(ii,6)=1/2*sum(svd(X-A));%trace    
    % Quantum Jensen Shannon
    h=@(x) sum(-x.*log2(x+(x==0)));    
    dist(ii,7)=h(svd(X+A)/2)-(h(svd(X))+h(svd(A)))/2;
    %Chernoff
    [Vr,Drho]=eig(A); Dr=diag(Drho); [Vs,Dsigma]=eig(X); Ds=diag(Dsigma); 
    C = abs(Vr'*Vs).^2;
    [~,Q]=fminbnd(@(s) (Dr.'.^s)*C*(Ds.^(1-s)), 0, 1);
    dist(ii,8)=sqrt(2-2*Q);
    %Quantum Hellinger
    dist(ii,9)=norm(sqrtm(X)-A12,'fro');
    %Sub Bures
    dist(ii,10)=sqrt(2-2*sqrt(trace(X*A)+sqrt((1-norm(X,'fro'))*(1-norm(A,'fro')))));
    end
end

%%
print_bold=@(x,y,v) text(x,y,v,'fontweight','bold','fontname','Times New Roman');
print_small=@(x,y,v) text(x,y,v,'fontsize',8,'fontname','Times New Roman');
lil=.07;
print_pretty_c=@(x) [print_bold(-.07,-.05,'C');print_bold(1,-.05,'C');
    print_bold(.45,1.1,'C');print_small(-.07+lil,-.05-lil,'3');
    print_small(1+lil,-.05-lil,'2');print_small(.45+lil,1.1-lil,'1');];

figure(2),clf
set(gcf,'position',get(gcf,'position').*[1 1 0  0]+[   0 0 1000   300]);
for ii=1:numel(measure_names)
subplot(2,5,ii)
plot([0 1 .5 0]',[0 0 1 0]','-k','linewidth',1)
hold all
contour(xi/2,yi,reshape(dist(:,ii),size(xi)),'linewidth',2)

[min_dist,~]=min(dist(:,ii));
min_idx=abs(dist(:,ii)-min_dist)<=1e-9;
plot(xi(min_idx)/2,yi(min_idx),'.k','markersize',9)

set(gca,'ytick',[],'xtick',[])
axis square
print_pretty_c(0);
set(gca,'ytick',[],'xtick',[],'box','off','visible','off')
color = get(gcf,'Color');
set(gca,'XColor',color,'YColor',color);
text(.5,1.3,measure_names{ii},'hor','center','fontsize',12,'Interpreter','latex')
colorbar
end

set(gcf,'paperpositionmode','auto')
saveas(gcf,'../results/Figure_2_demo_distances.eps','epsc2')
