info_func={...
    @(Z) bures_lb_embed_info(Z);
    };
func_names={...
    'Bures'...
};


thetas={[pi/60 -pi/60 pi/30+pi/30  -pi/30-pi/30];
    [pi/15 -pi/15 0  pi/2];
    [pi/15 -pi/15 0  pi];
    [pi/30 -pi/30 pi pi/2];
    [pi/30 -pi/30 pi*31/30 pi*29/30];
    [pi/30 -pi/30 pi/4 -pi/4];
    [pi/30 -pi/30 pi/4 -3*pi/4]+3*pi/4;
    [pi/30 -pi/30 pi/4 pi/2];
    [pi/2  -pi/2 0 pi];
    [pi/2  -pi/2 3*pi/4 -3*pi/4];
    [pi*2/3 -pi*2/3 0 pi]
    [pi*2/3 -pi*2/3 pi*3/4 -pi*3/4]
    };


info_val=nan(numel(thetas),numel(info_func));
entropy_val=nan(numel(thetas),1);

entropy_func=@(p) -p(:)'*log2((p(:)==0)+p(:));

corr_mat=cell(numel(thetas),1);
corr_mat_sorted=corr_mat;
for ii=1:numel(thetas)
    theta=thetas{ii};
    Z=[cos(theta);sin(theta)]; % embedding
    % compute informativeness directly from the embedding 
    for jj=1:numel(info_func)
        info_val(ii,jj)=info_func{jj}(Z);
    end
    %calculate 
    entropy_val(ii)=entropy_func(svd(Z).^2/norm(Z,'fro')^2);
    % Correlation matrix
    corr_mat{ii}=Z'*Z;
    % Form the graph Laplacian to get Fiedler vector for reordering the
    % correlation matrix
    L=diag(sum(corr_mat{ii},2))-corr_mat{ii};
    [U,~]=eigs(L,2,'SA');
    [~,idx]=min(sum(abs(U),1));
    [~,idx]=sort(U(:,idx));
    corr_mat_sorted{ii}=corr_mat{ii}(idx,idx);
end


%%

figure(1),clf
set(gcf,'position',get(gcf,'position').*[1 1 0 0]+[0 0   866   225*3/2])
subplot(4,numel(thetas),(1+3*numel(thetas)):4*numel(thetas))
[val,rankd]=sort(info_val(:,1));
h2=plot(1:numel(thetas),entropy_val(rankd));


my_gray=[.5 .25 .25];
set(h2,'linewidth',2,'linestyle',':','marker','x','color',my_gray,'markersize',10)
set(gca,'xtick',1:numel(thetas),'xgrid','on','xlim',[.55 numel(thetas)+.35])
set(gca,'fontsize',13)
legend('Entropy (bits) ','location','northwest')

set(gca,'xticklabel',[])
a_colormap=colormap(flipud(gray));

xticklabel={ cell(1,numel(thetas)),cell(1,numel(thetas))};
for ii=1:numel(thetas)
    subplot(4,numel(thetas),ii+numel(thetas))
    set(gca,'position',get(gca,'position')+[0 -.035 0 0])
    
    rectangle('position',[-1 -1 2 2],'Curvature',1,'linewidth',2,'edgecolor','w');
    hold all
    
    theta=thetas{rankd(ii)};
    plot([0*theta;cos(theta)]*.95,[0*theta;sin(theta)]*.95,'-k','linewidth',1.5,'markersize',10)
    plot(cos(theta),sin(theta),'ko','linewidth',1.5,'markersize',6)
    axis square
    xlabel('x')
    ylabel('y')
    set(gca,'visible','off')
    
    xticklabel{1}{ii}=sprintf('%.2f',val(ii));
    xticklabel{2}{ii}=sprintf('%.2f',entropy_val(rankd(ii)));
    
    subplot(4,numel(thetas),ii+2*numel(thetas))
    set(gca,'position',get(gca,'position')+[0 .035 0 0])
    
    mat2patch(corr_mat_sorted{rankd(ii)});

    colormap(flipud(gray))
    
    caxis([-1 1])
    axis square
    set(gca,'visible','off')
end

subplot(4,numel(thetas),1:numel(thetas))
h1=plot(1:numel(thetas),val);
set(h1,'linewidth',2,'linestyle',':','marker','x','color','k','markersize',10)
set(gca,'xtick',1:numel(thetas),'xgrid','on','xlim',[.55 numel(thetas)+.35])
set(gca,'fontsize',13)
legend('Informativeness ','location','northwest')
set(gca,'XAxisLocation','bottom','xticklabel',xticklabel{1})

subplot(4,numel(thetas),(1+3*numel(thetas)):4*numel(thetas))
set(gca,'XAxisLocation','top','xticklabel',xticklabel{2},'xcolor',my_gray)

set(gcf,'paperpositionmode','auto')
saveas(gcf,'../results/Figure_1_intro_embed_demo.eps','epsc2')

