have_minfunc=1;
if ~exist('minFunc.m','file')
    fprintf(['This script requires minFunc to be in the path in order to reproduce the results. \n',...
        'Original results using minFunc_2012:  \n',...
        ' https://www.cs.ubc.ca/~schmidtm/Software/minFunc.html\n',...
        ' then use the MATLAB command >> addpath(genpath(''XXX''))\n',...
        ' where XXX is the path to the minFunc_2012 directory\n'])
    while 1
        str=input('\n \n Do you want to continue with MATLAB''s fminunc instead?\n [yes] or no\n','s');
        if isempty(str)
            str='yes';
        end
        switch lower(str)
            case {'y','yes'}
                fprintf('Using MATLAB''s fminunc from the optimization toolbox instead');
                have_minfunc=0;
                break
            case {'n','no'}
                have_minfunc=-1;
                break;
        end
    end
end

if have_minfunc~=-1
    n=25;
    rng(880);
    
    dataset_names={'two', 'three', 'four','cos','box'};
    ndatasets = numel(dataset_names);
    all_input = cell(ndatasets,1);
    
    for mmm=1:ndatasets
        dataset_name=dataset_names{mmm};
        switch dataset_name
            case 'two'
                X=cat(1,randn(15,2),...
                    bsxfun(@plus,randn(10,2),5*[1 1]));
            case 'three'
                X=cat(1,randn(8,2),...
                    bsxfun(@plus,randn(9,2),5*[.5 1]),...
                    bsxfun(@plus,randn(8,2),5*[1 0]));
            case 'four'
                X=cat(1,randn(3,2),...
                    bsxfun(@plus,randn(9,2),5*[1 1]),...
                    bsxfun(@plus,randn(7,2),5*[0 1]),...
                    bsxfun(@plus,randn(6,2),5*[1 0]));
            case 'cos'
                X=linspace(0,2*pi,n+1).';
                X=[X,cos(X)];
            case 'box'
                [xx,yy]=meshgrid(linspace(0,10,sqrt(n)));
                X=[xx(:),yy(:)];
        end
        all_input{mmm}=X;
    end
    
    %%
    methods={'Euclidean','Cosine','HSIC','CKA','QH','Bures'};
    nmethods=numel(methods);
    all_rez = cell(nmethods,ndatasets,3);
    for mmm = 1:ndatasets
        for kk=1:numel(methods)
            metric=methods{kk};
            Y=all_input{mmm};
            if have_minfunc
                [Y,bandwidth]=info_minfunc(Y,metric);
            else
                [Y,bandwidth]=info_fminunc(Y,metric);
            end
            YY=Y*Y';
            Dnew=bsxfun(@plus,bsxfun(@plus,-2*YY,diag(YY)),diag(YY)');
            Knew=exp(-Dnew/2/bandwidth.^2);
            all_rez{kk,mmm,1}=Y;
            all_rez{kk,mmm,2}=Knew;
        end
    end
    %%
    
    color2=[0 114 178]/255;
    color3=[213 94 0]/255;
    figure(120),clf
    set(gcf,'position',get(gcf,'position').*[1 1 0 0]+[0 0 700 600])
    
    for mmm = 1:ndatasets
        inp=all_input{mmm};
        for kk=1:numel(methods)
            metric=methods{kk};
            rez=all_rez{kk,mmm,1};
            
            subplot(ndatasets,nmethods,kk+(mmm-1)*numel(methods))
            h=plot([inp(:,1)';rez(:,1)'],[inp(:,2)';rez(:,2)'],'-m','linewidth',2);
            set(h,'color',color3);
            hold all
            plot(inp(:,1),inp(:,2),'ok')
            h=plot(rez(:,1),rez(:,2),'bx','linewidth',2);
            set(h,'color',color2);
            
            axis equal
            aa=axis;
            axis(aa+[ [-1 1]*diff(aa(1:2))/20  [-1 1]*diff(aa(3:4))/20]);
            set(gca,'xtick',[],'ytick',[])
            
            if mmm==1
                title(metric,'fontweight','normal','fontsize',16)
            end
        end
    end
    set(gcf,'paperpositionmode','auto')
    saveas(gcf,'../results/Figure_12_a_sample_denoise','epsc2')
    
    %%
    figure(121),clf
    set(gcf,'position',get(gcf,'position').*[1 1 0 0]+[0 0 700 600])
    for mmm = 1:ndatasets
        
        Y=all_input{mmm};
        gamma=1/median(reshape(pdist(Y).^2,[],1));
        YY=Y*Y';
        Dnew=bsxfun(@plus,bsxfun(@plus,-2*YY,diag(YY)),diag(YY)');
        Knew=exp(-gamma*Dnew);
        subplot(ndatasets,nmethods+1,1+(mmm-1)*(numel(methods)+1))
        imagesc(Knew)
        
        axis square
        caxis([0 1])
        set(gca,'xtick',[],'ytick',[])
        colormap(flipud(gray))
        for kk=1:numel(methods)
            metric=methods{kk};
            Knew=all_rez{kk,mmm,2};
            subplot(ndatasets,nmethods+1,1+kk+(mmm-1)*(numel(methods)+1))
            imagesc(Knew)
            
            caxis([0 1])
            axis square
            set(gca,'xtick',[],'ytick',[])
            if mmm==1
                title(metric,'fontweight','normal','fontsize',16)
            end
        end
    end
    set(gcf,'paperpositionmode','auto')
    saveas(gcf,'../results/Figure_12_b_sample_denoise','epsc2')
end
