function [ vals ] = regular_graph_info(m,n,types)
vals=zeros(1,numel(types));
phat=m/(n*(n-1)/2);
if m>=1
    
    if m>=n
    half_deg=ceil(m/n);    
    I=mod(kron(1:n,ones(1,half_deg))+kron(ones(1,n),1:half_deg)-1,n)+1;
    J=kron(1:n,ones(1,half_deg));
    add_edges=half_deg*n-m;
        
    G=sparse([I,J],[J,I],1,n,n);
    
    G(2+(0:add_edges-1)*(n+1))=0;
    G(n+1+(0:add_edges-1)*(n+1))=0;
    [I,J]=find(tril(G));    I=I';    J=J';
    else
        I=[1:2:n-1,2:2:n-1];
        J=[2:2:n,3:2:n];
        I=I(1:m);
        J=J(1:m);        
    G=sparse([I,J],[J,I],1,n,n);
    end
    
    d=sum(G);
    d12=sqrt(1./d);
    nL=sparse([I,J,1:n],[J,I,1:n],[repmat(-d12(I).*d12(J),1,2),ones(1,n)],n,n);
        
    
    for method_ii=1:numel(types)
        if isa(types{method_ii}, 'function_handle')%informativeness function
            vals(method_ii)=types{method_ii}(nL);
        else
            switch types{method_ii}
                case {'bickel','eig1'}
                    Phat=phat*(1-eye(n));
                    A_P=(full(G)-Phat)/sqrt(phat*(1-phat)*(n-1));
                    A_P=(A_P+A_P')/2;
                    vals(method_ii)=eigs(A_P,1,'LA');
                case {'newman','mod'}
                    B=full(G)-d'*d/sum(d);
                    [Us,~]=eigs(B,1,'LA');%   compute largest eigenvector
                    s=Us>0;
                    vals(method_ii)=s'*B*s/(2*sum(d));
            end
        end
    end
end

