function [trace_dist,a,E] = trace_dist_info_fminbnd(rho )

n=size(rho,1);


%assume rho is correlation matrix
rho=rho/trace(rho)*n;
J=@(a) a+(1-a)*n/(n-1)*(eye(n)-1/n);%elliptope
D=@(a) sum(svd((rho-J(a))/(2*n)));
[a,trace_dist]=fminbnd(D,0,1);
if nargout>=3
E=(1-a)/(n-1)*(eye(n)-1/n)+a/n;
end


end

