function [dist,a,E] = quantum_hellinger_info(rho)
n=size(rho,1);
rho=rho/trace(rho)*n;
[U,S]=eig(full(rho));
pos_idx=diag(S)>eps;
rho12=U(:,pos_idx)*sqrt(S(pos_idx,pos_idx))*U(:,pos_idx)';

p1=sum(rho12(:))/sqrt(n);
rho12bar=mean(rho12,2);
tr_rho12c=sum(diag(rho12)-rho12bar); 
p2=sqrt(n/(n-1))*tr_rho12c;
a=p1^2/(p1^2+p2^2);
bcoef=sqrt(p1^2+p2^2);
dist=1-1*bcoef/n;

if nargout>=3
E=(1-a)/(n-1)*(eye(n)-1/n)+a/n;
J12=sqrt(a/n)+sqrt((1-a)*n/(n-1))*(eye(n)-1/n);
%fprintf('Difference %.02f\n',1e6*(dist-2*(1-J12(:)'*rho12(:)/n)))
end


end

