function dist = matrix_info_hsic_embed_general(Z )
%assume d by n
[m,n]=size(Z);
mu=mean(Z,2);
Zc=bsxfun(@minus,Z,mu);
if m<n
    Kcvec=Zc*Zc';
else
    Kcvec=Zc'*Zc;
end
trHK=Zc(:)'*Zc(:);
HKH_fro=sqrt(sum(Kcvec(:).^2));
dist=sqrt(max(0,HKH_fro^2/n^2-trHK^2/(n-1)/n^2));


