function [X,T] = denoiseInfoADMM(X0,T,lambda,rho)
[~,n]=size(X0);
niter=n*round(sqrt(n));
X=X0;
Z=X;
U=0*Z;

for iter=1:niter
    Xold=X;
    %X-step
    W=T/rho+(Z-U);
    pt_norms=sqrt(sum(W.^2,1));
    X=bsxfun(@times,W,1./max(1,pt_norms));
    
    %Z-step
    Z=infoProx(X+U,lambda/rho);
    
    %Update Lagrange multipliers
    U=U+X-Z;
    
    %check
    E=Xold-X;
    delta_X=(E(:)'*E(:))/(Xold(:)'*Xold(:));
    if iter>1 && delta_X<1e-6
        break;
    end
end

[psi,s,v]=svd(X,'econ');
X=s*v';
T=psi'*T;

end

