function [Z,keep_rank,u] = SOSST(Z,beta)
    St=@(s,t) max(0,s-t);
    [u,s,v]=svd(Z,'econ');
    [s,idx]=sort(diag(s),'descend');
    u=u(:,idx);
    v=v(:,idx);
    keep_rank=find(s-beta./(1+beta*(1:numel(s))').*cumsum(s)>0,1,'last');
    tau=beta/(1+beta*keep_rank)*sum(s(1:keep_rank));
    Z=u*diag(St(s,tau))*v';
end