%  This MATLAB code reproduces figures and tables from the paper 
%  Austin J. Brockmeier, Tingting Mu, Sophia Ananiadou, and John Y. Goulermas 
%  "Quantifying the Informativeness of Similarity Measurements",
%  Journal of Machine Learning Research, vol. 18, July, 2017.
% 
% Version 1.0	 July 11, 2017     Austin J. Brockmeier ajbrockmeier@gmail.com
% 
%  DISCLAIMER: THIS SOFTWARE IS PROVIDED BY THE AUTHORS "AS IS" AND ANY 
%  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
%  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
%  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
%  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
%  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
%  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
%  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
%  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
%  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
%  THE POSSIBILITY OF SUCH DAMAGE.
%
%  Warning: some scripts (Table 6, Figure 13, Figure 14, Table 9)
%  require an internet connection in order to download the relevant data
%  sets from the internet


FILELIST=dir('scripts/cmd_Figure_*.m');
figure_nums=arrayfun(@(x) sscanf(FILELIST(x).name,'cmd_Figure_%i_%*s'),1:numel(FILELIST)); 
[~,perm]=sort(figure_nums);
FILELIST=FILELIST(perm);

cd('scripts')
addpath(genpath('../functions/'))
addpath('../utilities/')
for FILE_NUM=1:numel(FILELIST)
    fprintf('Running %s\n',FILELIST(FILE_NUM).name)
    SCRIPT_TIME=tic;
    run(FILELIST(FILE_NUM).name);
    fprintf('%s took %.3f\n',FILELIST(FILE_NUM).name,toc(SCRIPT_TIME));
    save('temp.mat','FILE_NUM','FILELIST')
    clear all
    load('temp.mat','FILE_NUM','FILELIST')    
end
cd('..')

%%
FILELIST=dir('scripts/cmd_Table_*.m');
figure_nums=arrayfun(@(x) sscanf(FILELIST(x).name,'cmd_Table_%i_%*s'),1:numel(FILELIST)); 
[~,perm]=sort(figure_nums);
FILELIST=FILELIST(perm);

cd('scripts')
for FILE_NUM=1:numel(FILELIST)
    fprintf('Running %s\n',FILELIST(FILE_NUM).name)
    SCRIPT_TIME=tic;
    run(FILELIST(FILE_NUM).name);
    fprintf('%s took %.3f\n',FILELIST(FILE_NUM).name,toc(SCRIPT_TIME));
    save('temp.mat','FILE_NUM','FILELIST')
    clear all
    load('temp.mat','FILE_NUM','FILELIST')    
end
cd('..')

