function [ MInorm,VI,MI,H ] = compare_clusterings( true_labels,est_labels )
joint=[true_labels(:),est_labels(:)];
[sym,~,ic]=unique(joint,'rows');
N=size(sym,1);
MI=0;
for ii=1:N
    p_marg=prod(mean(bsxfun(@eq,sym(ii,:),joint)),2);
    p_joint=mean(ic==ii);
    MI=MI+p_joint*log2(p_joint/p_marg);
end

H=zeros(2,1);

for jj=1:2
[sym,~,ic]=unique(joint(:,jj));
N=size(sym,1);
for ii=1:N
    p_joint=mean(ic==ii);
    H(jj)=H(jj)+p_joint*-log2(p_joint);
end
end
VI=sum(H)-2*MI;%Meila, Marina (2003). "Comparing Clusterings by the Variation of Information". Learning Theory and Kernel Machines: 173?187.
MInorm = MI / max(H);
end

