info_func={@matrix_info_fro;
    @matrix_info_cosine;
    @matrix_info_hsic;
    @matrix_info_cka;
    @trace_dist_info_fminbnd;
    @jensen_shannon_info_fminbnd;
    @matrix_info_chernoff;
    @quantum_hellinger_info;
    @bures_info_fminbnd;
    @bures_lb_matrix_info;
    @bures_super_lb_matrix_info;
    };
func_names={'Euclidean',...
    'Cosine',...
    'HSIC',...
    'CKA',...
    'Trace',...
    'QJS',...
    'Chernoff',...
    'QH',...
    'Bures [exact]',...
    'Bures $i(\mathbf{K})$',...
    'Sub-Bures'};
markers={'none','none','none','none','none','none','none','none','none','none','none','o'};


linestyles={'-','--',':','-.','-','--',':','-.','-','--',':','.-'};

colors=[
    0 146 146;
    146 0 0 ;
    255 109 182;
    255 182 119;
    73 0 146;
    0 109 219;
    182 109 255;
    109 182 255;
    0 0 0;
    219 209 9;
    36 255 36;
    255 255 109]/255;
colors=mat2cell(colors,ones(size(colors,1),1),3);


linewidths=3*ones(numel(markers),1);
linewidths(9)=6;
markersizes=11*ones(numel(markers),1);

figure(6),clf
set(gcf,'position',get(gcf,'position').*[1 1 0 0]+ [0 0  480*2*4/3   640/2]);
set(gcf,'position',get(gcf,'position').*[1 1 0 0]+ [0 0   1015         300]);

n=16;
xx=0:n;
for fig_ii=1:2
    info_val=zeros(numel(xx),numel(info_func));
    kk=0;
    H=eye(n)-1/n;
    for ti=xx
        kk=kk+1;
        if fig_ii==1
            outer_product=@(x) x(:)*x(:)';            
            K=outer_product(cat(1,ones(ti,1),-ones(n-ti,1)));
        else
            %block case
            K=blkdiag(ones(ti),ones(n-ti));
        end
        for jj=1:numel(info_func)
            info_val(kk,jj)=info_func{jj}(K);
        end
    end    
    subplot(1,3,fig_ii)
    stem([.25 .5],2*[1 1],'k.','linewidth',2,'markersize',1,'marker','none')
    hold all
    h=plot(xx/n,info_val,'-o','linewidth',1.5,'markersize',11);
    for ii=1:numel(h)
        set(h(ii),'marker',markers{ii},'color',colors{ii},...
            'markersize',markersizes(ii),'linewidth',linewidths(ii),'linestyle',linestyles{ii});
    end
    gg=get(gca,'position');
    set(gca,'position',gg.*[1 1 .9 .9]+[0 gg(4)*.05 0 0]);
    set(gca,'fontsize',14)
    if fig_ii==1
        title('Rank-1 matrix','fontweight','normal');
        ylabel({'Informativeness'})
        xlabel('Relative size of first partition')
        text(0.25+0.025,0.05,'A','fontsize',16)
        text(0.5+0.025,0.05,'B','fontsize',16)
        set(gca,'ytick',[0 .25 .5 .75 1])
    else
        title('Block diagonal (2 blocks)','fontweight','normal')
        xlabel('Relative size of first block')
        set(gca,'ytick',[0 .25 .5 .75 1])        
        set(gca,'yticklabel',{})
        text(0.25+0.025,1-0.05,'C','fontsize',16)
        text(0.5+0.025,1-0.05,'D','fontsize',16)
    end
    set(gca,'TitleFontSizeMultiplier',1)
    set(gca,'ylim',[-.05 1.05])
    set(gca,'xtick',[0 .25 .5 .75 1 ],'xticklabel',[0 .25 .5 .75 1])
end
%%
info_val=[];
ent_vals=[];
for kk=1:n
    for jj=0:floor(n/(kk+1))
        the_rest=floor((n-jj)/kk*ones(1,kk));
        nk=sum(the_rest);
        for tt=1:n-nk-jj
            the_rest(tt)=the_rest(tt)+1;
        end
        cluster_sizes=[the_rest jj];
        cluster_sizes=cluster_sizes(cluster_sizes>0);
        K=recursblkdiag(cluster_sizes);
        
        p=cluster_sizes/n;
        p=p.*(p>0);
        am=sum(-p.*log2(p+(p==0)));
        ent_vals=cat(1,ent_vals,[am,jj]);
        
        vals=zeros(1,numel(info_func));
        for ii=1:numel(info_func)
            vals(ii)=info_func{ii}(K);
        end
        info_val=cat(1,info_val,vals);
    end
end

yheight=2;
subplot(1,3,3)
idx=ent_vals(:,2)==0 & any(abs(bsxfun(@minus,ent_vals(:,1),0:1:log2(n)))<1e-9,2);
stem(ent_vals(idx,1),yheight*ones(sum(idx),1),'k.','linewidth',2,'markersize',1,'marker','none')
hold all
ent_c=(1/2+3/4*log2(4/3));
stem(ent_c,yheight,'k.','linewidth',2,'markersize',1,'marker','none')


h=plot(ent_vals(:,1),info_val,'o-','linewidth',1.5,'markersize',11);
for ii=1:numel(h)
    set(h(ii),'marker',markers{ii},'color',colors{ii},'linewidth',linewidths(ii),'linestyle',linestyles{ii});
end
set(gca,'fontsize',14)
gg=get(gca,'position');
set(gca,'position',gg.*[1 1 .9 .9]+[0 gg(4)*.05 0 0]);
legs=func_names;
hl=legend(h,legs,'location','southwest','Interpreter','latex');
set(hl,'position',[0.8845 0.1880 0.1398 0.6964])


title('Block diagonal','fontweight','normal')
set(gca,'TitleFontSizeMultiplier',1)
xlabel('von Neumann entropy (bits)')
set(gca,'ylim',[-.05 1.05])
set(gca,'ytick',[0 .25 .5 .75 1])
set(gca,'yticklabel',{})

text(ent_c-0.3,1-0.05,'C','fontsize',16)
text(1+0.05,1-0.05,'D','fontsize',16)
text(2+0.05,1-0.05,'E','fontsize',16)
text(3+0.05,1-0.05,'F','fontsize',16)

set(gca,'xlim',[-.1 4.1])
set(gca,'xtick',0:4);
set(gcf,'paperpositionmode','auto')

saveas(gcf,'../results/Figure_6_patterned_landscape.eps','epsc2')

