info_func={@matrix_info_fro;%1
    @matrix_info_cosine;%2
    @matrix_info_hsic;%3
    @matrix_info_cka;%4
    @trace_dist_info_fminbnd;%5
    @jensen_shannon_info_fminbnd;%6
    @matrix_info_chernoff;%7
    @quantum_hellinger_info;%8
    @bures_info_fminbnd;%9
    @bures_lb_matrix_info;%10
    @bures_super_lb_matrix_info;%11
    @matrix_info_lawley;%12
    @matrix_info_bartlett;%13
    };

measure_names={     'Euclidean',...
    'Cosine',...
    'HSIC',...
    'CKA',...
    'Trace',...
    'QJS',...
    'Chernoff',...
    'QH',...
    'Bures [exact]',...
    'Bures $i(\mathbf{K})$',...
    'Sub-Bures',...
    'Lawley',...
    'Bartlett'};

v1=[-1 1 1]'; v2=[1 -1 1]'; v3=[1 1 -1]'; o=[1 1 1]';
C1=v1*v1'; C2=v2*v2'; C3=v3*v3'; J=o*o';

Ks={C1 J (C2+C3)/2};
[xi,yi] = meshgrid(linspace(0,2,60),linspace(0,1,60));
alpha=cat(1,yi(:)',.5*xi(:)'-.5*yi(:)',1-(xi(:)'+yi(:)')/2);


N=numel(xi);
info_val=nan(N,numel(info_func));
for ii=1:numel(xi)
    if all(alpha(:,ii)>0)
        K=(alpha(1,ii)*Ks{1}+alpha(2,ii)*Ks{2}+alpha(3,ii)*Ks{3})/3;
        for jj=1:numel(info_func)
            info_val(ii,jj)=info_func{jj}(K);
        end
    end
end

%%
print_bold=@(x,y,v) text(x,y,v,'fontweight','bold','fontname','Times New Roman');
print_small=@(x,y,v) text(x,y,v,'fontsize',8,'fontname','Times New Roman');
print_normal=@(x,y,v) text(x,y,v,'fontsize',12,'fontname','Times New Roman');
lil=.07;


dist=info_val(:,:);

figure(5),clf
set(gcf,'position',get(gcf,'position').*[1 1 0  0]+[0 0 1000   450]);

print_pretty_c=@(x) [print_normal(-.15,-.1,'(    +     )/2'); 
                     print_bold(-.15,-.1,'  C     C');
                     print_bold(1,-.05,'J');
                     print_bold(.45,1.1,'C');
                     print_small(-.15+lil,-.1-lil,'    2       3');
                     print_small(1+lil,-.05-lil,'');
                     print_small(.45+lil,1.1-lil,'1');];
                 
reorder=[ 9 1 2 3 4, 5 6 7 8 11 ,  10 13  12 14 15];
for jj=1:numel(reorder)
    ii=reorder(jj);
    if ii<=size(dist,2)
        subplot(3,5,jj)
        plot([0 1 .5 0]',[0 0 1 0]','-k','linewidth',1)
        hold all
        contour(xi/2,yi,reshape(dist(:,ii),size(xi)),quantile(dist(:,ii),5),'linewidth',2);
        ctemp=caxis;
        xytemp=axis;
        
        [min_dist,~]=min(dist(:,ii));
        min_idx=abs(dist(:,ii)-min_dist)/max(dist(:,ii))<=1e-5;
        plot(xi(min_idx)/2,yi(min_idx),'.k','markersize',9)
        colormap(flipud(parula))
        set(gca,'ytick',[],'xtick',[])
        axis square
        print_pretty_c(0);
        set(gca,'ytick',[],'xtick',[],'box','off','visible','off')
        color = get(gcf,'Color');
        set(gca,'XColor',color,'YColor',color);
        text(.5,1.3,measure_names{ii},'hor','center','fontsize',12,'Interpreter','latex')
        colorbar
    end
end

set(gcf,'paperpositionmode','auto')
saveas(gcf,'../results/Figure_5_demo_info_cutface_reorder.eps','epsc2')
