n=100;
%make the set of basis vectors
V=tril(ones(n));
V(V==0)=-1;% cut vectors 
V=cat(2,V,-1*ones(n,1));%for symmetry the all -1's vector 


funcs={... % Exact Bures for rank-1 corrrelation matrix
    @(x) 1-2/n*max(sqrt(sum(x==1)*(n-sum(x==1))/(n-1)),abs(sum(x==1)-n/2)),...
    ... % Bures-based informativeness (based on lower bound of Bures distance)
    @(x)  bures_lb_matrix_info(x*x')};

vals=zeros(n,numel(funcs));
for ii=1:size(V,2);
    K=V(:,ii)*V(:,ii)';
    for jj=1:numel(funcs)
        vals(ii,jj)=funcs{jj}(V(:,ii));
    end
end

%%

for fig_ii=1:2
    figure(150+fig_ii-1),clf
    set(gcf,'position',get(gcf,'position').*[1 1 0 0]+ [0 0 310 232])
    if fig_ii==1
        subfig='a';
        h=plot(sum(V==1),sqrt(2*vals(:,1)),'k-','linewidth',3);
        set(h,'color',[.5 .5 .5])
        hold all
        h=plot(sum(V==1),sqrt(2*vals(:,2)),'k-','linewidth',3);
        axis([-1 101  0    1.4])
        set(gca,'ytick',[0 0.2 0.4 0.6 0.8  1 1.2 1.4])
    else
        subfig='b';
        h=plot(sum(V==1),sqrt(2*vals(:,1)),'-ko','markersize',9,'linewidth',3);
        set(h,'color',.5*[1 1 1],'markerfacecolor',[.5 .5 .5],'markeredgecolor','none')
        hold all
        h=plot(sum(V==1),sqrt(2*vals(:,2)),'-kx','markersize',10,'linewidth',3);
        axis([43  57    1.3    1.35])

    end
    title('Rank-1 matrix','fontweight','normal');
    set(gca,'TitleFontSizeMultiplier',1)
    legs={'$d_\mathcal{N} (\mathbf{K})$', '$\sqrt{2 i(\mathbf{K})}$'};
    set(gca,'fontsize',14)
    legend(legs,'location','south','Interpreter','latex','fontsize',14)
    xlabel('$c$ (for $n=100$)','Interpreter','latex')
    set(gcf,'paperpositionmode','auto')
    saveas(gcf,['../results/Figure_15_rank1_',subfig],'epsc2')
end
