nmethods=9;
ndatasets=5;
results=cell(ndatasets,1);
dataset_names={'ORL','MNIST','COIL20','UMIST','USPS'};

for dataset_ii=1:numel(dataset_names)
    rng(880);%set random stream
    dataset_name=dataset_names{dataset_ii};
    getData(dataset_name)    
    switch dataset_name
        case 'ORL'
            load ../data/orl_faces/orl.mat
            num_topics=max(fig_label);
            Y=fig_label;
            clear fig_label
            fea=reshape(images,numel(Y),[]);
            clear images;
        case 'MNIST'
            load ../data/mnist/mnist_test.mat
            Y=test_labels;
            clear test_labels
            num_topics=max(Y);
            fea=test_X;
            clear test_X;
        case 'COIL20'
            load ../data/coil-20-proc/coil20.mat
            Y=fig_label(:,1);
            clear fig_labels
            num_topics=max(Y);
            fea=images;
            clear images;
        case 'UMIST'
            load('../data/umist/umist_cropped.mat','facedat')
            Y=cell2mat(cellfun(@(x,y) y*ones(size(x,3),1),facedat(:),num2cell((1:numel(facedat))'),'uni',0));
            fea=cell2mat(cellfun(@(x) reshape(double(x),[],size(x,3))',facedat(:),'uni',0));
            clear facedat
            num_topics=max(Y);
        case 'USPS'
            load '../data/usps/usps.mat'
            fea=images;
            clear images;
            Y=Y+1;
            num_topics=max(Y);
    end
    kcluster=3;
    N_keep=200;
    
    stats=zeros(8,nmethods);
    
    tt=randperm(num_topics);
    current_topics=tt(1:kcluster);
    
    included_ind= ismember(Y,current_topics);
    doc_idx=Y(included_ind);
    outoforder=randperm(numel(doc_idx));
    inc_idx = sort(outoforder(1:min(numel(doc_idx),N_keep)));
    doc_labels=doc_idx(inc_idx);
    
    x=fea(included_ind,:);
    x=x(inc_idx,:);
    XX=full(x*x');
    D2=bsxfun(@plus,diag(XX),bsxfun(@plus,diag(XX)',-2*XX));
    Dtemp=sort(D2);
    sig_max = sqrt(max(Dtemp(end,:)));
    Dtemp(Dtemp==0)=inf;
    dt=sqrt(min(reshape(Dtemp(2:end,:),[],1)));
    sig_min = 2*dt;
    N_sigma=15;
    sigmas=linspace(sig_min,sig_max,N_sigma)';
    sigma_ii=4;
    sigma=sigmas(sigma_ii);
    K=exp(-D2/(2*sigma^2));
    K=(K+K')/2;
    
    tic
    [W,Ws]=denoiseInfo(K,size(K,1),1);
    tW=toc;
    tZ=tW;
    %KPCA
    H=eye(size(K,1))-1/size(K,1);
    Ac=H*K*H;
    [uu,ll]=eig(Ac);
    [ll,idx]=sort(diag(ll),'descend');
    uu=uu(:,idx);
    ll=diag(ll);
    PC=uu*sqrt(ll.*(ll>0));
    %KEIG
    [vv,ss]=eig(K);
    [ss,idx]=sort(diag(ss),'descend');
    vv=vv(:,idx);
    ss=diag(ss);    
    Z=vv*sqrt(ss.*(ss>0));
    
    results{dataset_ii}={K,doc_labels,Ws,Z,PC};
end

%%
stat_pile=cell(ndatasets,1);

remap=[3 4 5 4 5];
normmap=[1 1 1 0 0];
for dataset_ii=1:ndatasets
    
    K=results{dataset_ii}{1};
    labels=results{dataset_ii}{2};
    H=eye(size(K,1))-1/size(K,1);
    Ac=H*K*H;
    
    stat=nan(numel(remap),size(K,1),4);
    for jj=1:numel(remap)
        
        Wall=results{dataset_ii}{remap(jj)};
        for k=floor(sqrt(size(K,1))):size(K,1)
            if iscell(Wall)
                Ws=Wall;
                w_ranks=cellfun(@(x) size(x,2),Ws);
                Ws=Ws(w_ranks>0);
                w_ranks=w_ranks(w_ranks>0);
                k_idx=find(w_ranks<=k,1,'first');
                if ~isempty(k_idx)
                    W=Ws{k_idx};
                else
                    W=Ws{end};
                end
            else
                W=Wall(:,1:k);
            end
            if normmap(jj)==1
                W=bsxfun(@rdivide,W,sqrt(sum(W.^2,2)));
            end
            stat(jj,k,1)=size(W,2);
            
            un_lab=unique(labels);
            Y=1*bsxfun(@eq,labels,un_lab');% embedding of training labels
            Yc=bsxfun(@minus,Y,mean(Y,1));%centered
            Yc_2=Yc/sqrt(sqrt(sum(reshape(Yc'*Yc,[],1).^2))); %  ||y*y'||_F=1
            
            Zc=bsxfun(@minus,W,mean(W,1))';% centered
            Zc2=Zc/sqrt(sqrt(sum(reshape(Zc*Zc',[],1).^2))); %  Schatten-2 normalized
            stat(jj,k,2)=norm(Zc2*Yc_2,'fro');
            stat(jj,k,3)=bures_lb_embed_info(W');
            stat(jj,k,4)=norm(W*W'-K,'fro')/norm(K,'fro');
            
        end
    end
    stat_pile{dataset_ii}=stat;
end


%%
n_across=7;
aperm=[3 1 2 4 5 6 0 0];
% 2     3     1
% Z     PC    W
% trun        denoise blur
figure(14),clf
set(gcf,'position',get(gcf,'position').*[ 1 1 0 0]+[0 0 861   614]);
for dataset_ii=1:ndatasets
    datasetname=dataset_names{dataset_ii};
    
    K=results{dataset_ii}{1};
    k=ceil(sqrt(size(K,1)));
    labels=    results{dataset_ii}{2};
    for jj=1:3
        W=results{dataset_ii}{2+jj};
        
        if iscell(W)
            Ws=W;
            w_ranks=cellfun(@(x) size(x,2),Ws);
            Ws=Ws(w_ranks>0);
            w_ranks=w_ranks(w_ranks>0);
            k_idx=find(w_ranks<=k,1);
            if ~isempty(k_idx)
                W=Ws{k_idx};
            else
                W=Ws{end};
            end
        else
            W=W(:,1:k);
        end
        
        Z=W';
        Zsphr=bsxfun(@times,Z,1./sqrt(sum(Z.^2,1)));%spherical embedding
        %
        info1=bures_lb_matrix_info(K);
        info2=bures_lb_embed_info(Zsphr);
        %
        H=eye(size(K,1))-1/size(K,1);
        Kc=H*K*H;
        Kc2=Kc/norm(Kc,'fro');
        un_lab=unique(labels);
        Y=1*bsxfun(@eq,labels,un_lab');% embedding of training labels
        Yc=bsxfun(@minus,Y,mean(Y));%centered
        Yc_2=Yc/sqrt(sqrt(sum(reshape(Yc'*Yc,[],1).^2))); %  ||y*y'||_F=1
        Zc=bsxfun(@minus,Z,mean(Z,2));% centered
        Zc2=Zc/sqrt(sqrt(sum(reshape(Zc*Zc',[],1).^2))); %  Schatten-2 normalized
        ca2=norm(Zc2*Yc_2,'fro');
        
        ca1=trace(Yc_2'*Kc2*Yc_2);
        
        subplot(ndatasets,n_across,2+aperm(jj)+(dataset_ii-1)*n_across)
        imagesc(W*W')
        axis square
        colormap(flipud(gray))
        if dataset_ii==1
            switch jj
                case 1
                    title({'Denoise'},'fontweight','normal')
                case 2
                    title({'Truncate','KEIG'},'fontweight','normal')
                case 3
                    title({'Center truncate','KPCA'},'fontweight','normal')
            end
        end
        set(gca,'xtick',[]);
        caxis(caxis.*[1 0]+[0 1])
        set(gca,'ytick',[])
    end
    subplot(ndatasets,n_across,2+(dataset_ii-1)*n_across)
    imagesc(K)
    axis square
    if dataset_ii==1
        title(sprintf('Kernel matrix'),'fontweight','normal')
    end
    set(gca,'xtick',[]);
    set(gca,'ytick',[])
    caxis(caxis.*[1 0]+[0 1])
    
    subplot(ndatasets,n_across,1+(dataset_ii-1)*n_across)
    imagesc(bsxfun(@eq,labels,labels'));
    axis square
    if dataset_ii==1
        title('Class label matrix','fontweight','normal');
    end
    ylabel(datasetname)
    set(gca,'xtick',[]);
    caxis(caxis.*[1 0]+[0 1])
end

markers={'o','+','none','none','none'};
linestyles={'none','none','-','--',':'};
colors={[0,0,0]/255,[166,97,26]/255,[128,205,193]/255,[223,194,125]/255,[1,133,113]/255};

keep_idx=1:3;

stat_names={'CKA to labels','Informativeness'};
for dataset_ii=1:ndatasets
    stat=stat_pile{dataset_ii};
    for stat_ii=1:2
        subplot(ndatasets,n_across,(dataset_ii-1)*n_across+5+stat_ii)
        if stat_ii==1
            hs=plot(stat(keep_idx,:,1)',stat(keep_idx,:,2)','o-','linewidth',2);
        else
            hs=plot(stat(keep_idx,:,1)',stat(keep_idx,:,3)','o-','linewidth',2);
        end
        for gii=1:numel(hs)
            set(hs(gii),'marker',markers{keep_idx(gii)},'linestyle',linestyles{keep_idx(gii)},'color',colors{keep_idx(gii)})
        end
        axis tight
        K=results{dataset_ii}{1};
        k=ceil(sqrt(size(K,1)));
        tt=ceil(linspace(k,size(K,1),3)/5)*5;
        tt(1)=k;
        set(gca,'xtick',tt);
        set(gca,'xlim',[tt(1)-range(tt)/10 tt(end)+range(tt)/10])
        tt=get(gca,'ylim');
        set(gca,'ylim',[tt(1)-range(tt)/5 tt(end)+range(tt)/5])
        
        if dataset_ii==1
            title(stat_names{stat_ii},'fontweight','normal');
            xlabel('rank')
            if stat_ii==2
                h=legend(hs([2 3 1]),{'KEIG','KPCA','Denoise'},'location','east');
                set(h,'position',[ 0.9036    0.8697    0.0877    0.0546]);
            end
        end
    end
end

set(gcf,'paperpositionmode','auto')
saveas(gcf,'../results/Figure_14_denoise_example','epsc2')

