if ~exist('minFunc.m','file') && ~exist('../results/usps_denoise_results.mat','file')
    warning(['This script requires minFunc to be in the path in order to reproduce the results. ',...
        'Original results using minFunc_2012:  ',...
        ' https://www.cs.ubc.ca/~schmidtm/Software/minFunc.html',...
        ' then use the MATLAB command >> addpath(genpath(''XXX''))',...
        ' where XXX is the path to the minFunc_2012 directory'])
else
    
    % Data from
    %  http://web.stanford.edu/~hastie/ElemStatLearn/
    % Normalized handwritten digits, automatically
    % scanned from envelopes by the U.S. Postal Service. The original
    % scanned digits are binary and of different sizes and orientations; the
    % images  here have been deslanted and size normalized, resulting
    % in 16 x 16 grayscale images (Le Cun et al., 1990).
    %
    % The data are in two gzipped files, and each line consists of the digit
    % id (0-9) followed by the 256 grayscale values.
    %
    % There are 7291 training observations and 2007 test observations,
    % distributed as follows:
    %          0    1   2   3   4   5   6   7   8   9 Total
    % Train 1194 1005 731 658 652 556 664 645 542 644 7291
    %  Test  359  264 198 166 200 160 170 147 166 177 2007
    %
    % or as proportions:
    %          0    1   2    3    4    5    6    7    8    9
    % Train 0.16 0.14 0.1 0.09 0.09 0.08 0.09 0.09 0.07 0.09
    %  Test 0.18 0.13 0.1 0.08 0.10 0.08 0.08 0.07 0.08 0.09
    %
    %
    % Alternatively, the training data are available as separate files per
    % digit (and hence without the digit identifier in each row)
    %
    % The test set is notoriously "difficult", and a 2.5% error rate is
    % excellent. These data were kindly made available by the neural network
    % group at AT&T research labs (thanks to Yann Le Cunn).
     getData('usps')
    load '../data/usps/usps.mat'
    hor_pix=16;
    rng(880);
    labels=Y;
    pp=[];
    for ii=1:10
        L=find(labels==(ii-1));
        p=randperm(numel(L));
        pp=cat(1,pp,L(p(1:40)));
    end
    labels=labels(pp);
    
    %%
    n_horizontal=10;
    Y=images(pp,:);
    image_arrange=@(YY) cell2mat(reshape(cellfun(@(x) reshape(x,hor_pix,[]).',mat2cell(YY,ones(size(Y,1),1),size(Y,2)),'uni',0),n_horizontal,[]).');
    
    figure(1300),clf
    set(gcf,'position',get(gcf,'position').*[1 1 0 0]+[0 0 290 580])
    imagesc(image_arrange(Y))
    axis equal
    colormap gray
    set(gca,'visible','off')
    set(gcf,'paperpositionmode','auto')
    saveas(gcf,'../results/Figure_13_usps_digits','epsc2')
    
    %%
    if ~exist('../results/usps_denoise_results.mat','file')
        methods={'Euclidean','Cosine','HSIC','CKA','Bures','QH'};
        timing=zeros(numel(methods),1);
        Ynew=cell(numel(methods),1);
        bw=zeros(numel(methods),1);
        
        for kk=1:numel(methods)
            tic;
            [Ynew{kk},bw(kk)]=info_minfunc(Y,methods{kk});
            timing(kk)=toc;
        end
        %%
        save('../results/usps_denoise_results','timing','Ynew','bw','methods');
    else
        load('../results/usps_denoise_results','timing','Ynew','bw','methods');
    end
    %% evaluate centered alignment
    
    ca=zeros(numel(methods)+1,1);
    for kk=1:numel(methods)+1
        if kk>numel(methods)
            Y=images(pp,:);
        else
            Y=Ynew{kk};
        end
        YY=Y*Y';
        Y2=diag(YY);
        D2=bsxfun(@minus,bsxfun(@minus,2*(Y*Y'),Y2),Y2');
        
        un_lab=unique(labels);
        Y=1*bsxfun(@eq,labels,un_lab');% embedding of training labels
        Yc=bsxfun(@minus,Y,mean(Y));%centered
        Yc_2=Yc/sqrt(sqrt(sum(reshape(Yc'*Yc,[],1).^2))); %  ||y*y'||_F=1
        
        H=eye(size(Y,1))-1/size(Y,1);
        if kk>numel(methods)
            Kc=@(x) H*exp(10^x*D2)*H;
            Kc2=@(x) Kc(x)/norm(Kc(x),'fro');
            [gamma,ca0]=fminbnd(@(x) -trace(Yc_2'*Kc2(x) *Yc_2),-5,5);
            bandwidth=sqrt(1/(2*10^gamma));
        else
            bandwidth=bw(kk);
        end
        
        gamma=log10(1/(2*bandwidth^2));
        K=exp(10^gamma*D2);
        
        Kc=H*K*H;
        Kc2=Kc/norm(Kc,'fro');
        ca(kk)=trace(Yc_2'*Kc2*Yc_2);
    end
    
    
    %% evaluate clustering
    kcluster=10;
    rng(880);
    
    nmi=zeros(numel(methods)+1,1);
    for kk=1:numel(methods)+1
        if kk>numel(methods)
            Y=images(pp,:);
        else
            Y=Ynew{kk};
        end
        YY=Y*Y';
        Y2=diag(YY);
        D2=bsxfun(@minus,bsxfun(@minus,2*(Y*Y'),Y2),Y2');
        
        Y=1*bsxfun(@eq,labels,un_lab');% embedding of training labels
        Yc=bsxfun(@minus,Y,mean(Y));%centered
        Yc_2=Yc/sqrt(sqrt(sum(reshape(Yc'*Yc,[],1).^2))); %  ||y*y'||_F=1
        
        H=eye(size(K,1))-1/size(K,1);
        
        if kk>numel(methods)
            Kc=@(x) H*exp(10^x*D2)*H;
            Kc2=@(x) Kc(x)/norm(Kc(x),'fro');
            [gamma,ca0]=fminbnd(@(x) -trace(Yc_2'*Kc2(x) *Yc_2),-5,5);
            bandwidth=sqrt(1/(2*10^gamma));
        else
            bandwidth=bw(kk);
        end
        gamma=log10(1/(2*bandwidth^2));
        K=exp(10^gamma*D2);
        %Ng Jordan Weiss spectral clustering
        K(1:size(K,1)+1:end)=0;
        d=sum(K,2);
        d(d<1e-9)=1;
        
        K=bsxfun(@rdivide,bsxfun(@rdivide,K,sqrt(d)),sqrt(d'));
        K=(K+K.')/2;
        
        [Ua,S]=eigs(K,kcluster,'la');
        s=diag(S);[~,idx]=sort(s,'descend');
        Ua=Ua(:,idx);
        U=Ua(:,1:kcluster);
        U=bsxfun(@rdivide,U,sqrt(sum(U.^2,2)));
        
        cluster_idx=kmeans(U,kcluster);
        
        nmi(kk)=compare_clusterings(labels,cluster_idx);
    end
    
    
    %% make Table 8
    fprintf('\n')
    reorder = [7 1 2 3 4 6 5];
    fprintf('%20s','')
    cellfun(@(x) fprintf('%11s ',x),[{'Original'};methods(reorder(2:end)).'])
    fprintf('\n')
    
    fprintf('%20s','CA to labels: ')
    arrayfun(@(x) fprintf('%11.2f ',x),ca(reorder))
    fprintf('\n')
    fprintf('%20s','NMI: ')
    arrayfun(@(x) fprintf('%11.2f ',x),nmi(reorder))
    fprintf('\n')
    fprintf('%20s','Time (s): ')
    arrayfun(@(x) fprintf('%11.2f ',x),[nan;timing(reorder(2:end))])
    fprintf('\n ')
    
    fid=fopen('../results/Table_6.txt','w');
    fprintf(fid,'%20s','');
    cellfun(@(x) fprintf(fid,'%11s ',x),[{'Original'};methods(reorder(2:end)).'])
    fprintf(fid,'\n');
    
    fprintf(fid,'%20s','CA to labels: ');
    arrayfun(@(x) fprintf(fid,'%11.2f ',x),ca(reorder))
    fprintf(fid,'\n');
    fprintf(fid,'%20s','NMI: ');
    arrayfun(@(x) fprintf(fid,'%11.2f ',x),nmi(reorder));
    fprintf(fid,'\n');
    fprintf(fid,'%20s','Time (s): ');
    arrayfun(@(x) fprintf(fid,'%11.2f ',x),[nan;timing(reorder(2:end))])
    fclose(fid);
    
    
    %%
    
    Y=images(pp,:);
    bandwidth=1;
    YY=Y*Y';
    Y2=diag(YY);
    D2=bsxfun(@minus,bsxfun(@minus,2*(Y*Y'),Y2),Y2');
    gamma=log10(1/median(squareform(-D2)));
    K=exp(10^gamma*D2);
    
    figure(1310),clf
    set(gcf,'position',get(gcf,'position').*[1 1 0 0]+[0 0 580 580])
    
    imagesc(K)
    %title(methods{kk},'fontweight','normal')
    axis equal
    set(gca,'visible','off')
    colormap(flipud(gray))
    caxis([0 1])
    set(gcf,'paperpositionmode','auto')
    saveas(gcf,'../results/Figure_13_usps_corr','epsc2')
    
    
    %%
    for kk=1:numel(methods)
        
        Y=Ynew{kk};
        bandwidth=bw(kk);
        gamma=log10(1/(2*bandwidth^2));
        YY=Y*Y';
        Y2=diag(YY);
        D2=bsxfun(@minus,bsxfun(@minus,2*(Y*Y'),Y2),Y2');
        K=exp(10^gamma*D2);
        
        figure(1310+kk),clf
        set(gcf,'position',get(gcf,'position').*[1 1 0 0]+[0 0 580 580])
        
        imagesc(K)
        axis equal
        set(gca,'visible','off')
        colormap(flipud(gray))
        caxis([0 1])
        
        set(gcf,'paperpositionmode','auto')
        saveas(gcf,sprintf('../results/Figure_13_usps_corr_%s.eps',methods{kk}),'eps2')
        
    end
    
    %%
    for kk=1:numel(methods)
        figure(1300+kk),clf
        set(gcf,'position',get(gcf,'position').*[1 1 0 0]+[0 0 290 580])
        imagesc(image_arrange(Ynew{kk}))
        %title(methods{kk},'fontweight','normal')
        axis equal
        set(gca,'visible','off')
        colormap gray
        set(gcf,'paperpositionmode','auto')
        saveas(gcf,sprintf('../results/Figure_13_usps_digits_%s.eps',methods{kk}),'eps2')
    end
end