if ~exist('../results/ER_edge_count_measure_vals_eig_degrees.mat','file')
    rng(880);

    n=100;
    info_funs={@(x) matrix_info_fro(x),@(x) matrix_info_cosine(x),...
        @(x) matrix_info_hsic(x),@(x) matrix_info_cka(x),...
        @(x) matrix_info_chernoff(full(x)),...
        @(x) quantum_hellinger_info(x),@(x) bures_lb_matrix_info(x),...
        @(x) bures_super_lb_matrix_info(x),...
        @(x) matrix_info_bartlett(x), @(x) matrix_info_lawley(x)};
    
    ngraphs=7;
    dbar=cell(ngraphs,1);
    info=cell(ngraphs,numel(info_funs));
    eig1=cell(ngraphs,2);
    
    for graph_ii=[1:4 6]
        nmonte=10;
        ks=1;
        switch graph_ii
            case {1,2}
                ps=logspace(log10(1/n^2),log10(.9),20);
            case 3
                ps=1:n-1;%degrees
                nmonte=1;
            case 4
                ps=1:n-1;%degrees
            case {6,7}
                ks=[2 4 8 10 15 20];
                ps=unique(round(linspace(1,n-1,20)));%degrees
        end
        dbar{graph_ii}=nan(numel(ps),nmonte,numel(ks));
        
        for method_ii=1:numel(info_funs);
            info{graph_ii,method_ii}=nan(size(dbar{graph_ii}));
        end
        eig1{graph_ii,1}=nan(size(dbar{graph_ii}));
        eig1{graph_ii,2}=nan(size(dbar{graph_ii}));
        
        for k_ii=1:numel(ks)
            
            for p_ii=1:numel(ps)
                p=ps(p_ii);
                degree=p;
                monte_ii=1;
                for monte_ii=1:nmonte
                    if graph_ii==1
                        
                        Ibase=mod(randi(n-1,1,n)+n-1,n)+1;
                        Jbase=1:n;
                        if p<.1
                            m=binornd(n*(n-1)/2,p);
                            inner_tri_idx=randperm(n*(n-1)/2,m);
                            
                            I=inner_tri_idx;
                            J=ones(size(I));
                            col_count=n-1;
                            for cc=1:n-1
                                ub=col_count;
                                lb=col_count-(n-cc);
                                idx= inner_tri_idx<=ub &   inner_tri_idx>lb;
                                I(idx)=inner_tri_idx(idx)-lb+cc;
                                J(idx)=cc;
                                col_count=col_count+(n-cc-1);
                            end
                            
                            G=sparse([I,J],[J,I],1,n,n);
                            d=sum(G);
                            d12=sqrt(1./d);
                            nL=sparse([I,J,1:n],[J,I,1:n],[repmat(-d12(I).*d12(J),1,2),ones(1,n)],n,n);
                        else
                            Gl=tril(rand(n)<=p,-1);
                            G=Gl+Gl';
                            
                            d=sum(G);
                            d12=min(1,sqrt(1./d));
                            L=diag(d)-G;
                            nL=eye(n)-bsxfun(@times,bsxfun(@times,G,d12),d12');
                        end
                    else
                        switch graph_ii
                            case 2 %Barabasi-Albert model
                                %R. Albert and A. L. Barabsi, Statistical mechanics of complex networks,
                                % Reviews of Modern Physics, vol. 74, no. 1, pp. 47--97, 2002.
                                if p<.5
                                    m=ceil((n-sqrt(n^2-2*n*(n-1)*p))/2);
                                    m_0=m;
                                    t=n-m_0;
                                    M=m*t;
                                    d=cat(1,ones(m,1),m,zeros(n-m-1,1));
                                    I=[1:m,nan(1,M-m)];
                                    J=[(m_0+1)*ones(1,m),nan(1,M-m)];
                                    for cc=2:t
                                        Pi=d/sum(d);
                                        ii=zeros(1,m);
                                        for jj=1:m
                                            x=rand(1);
                                            i=find(x<=cumsum(Pi),1,'first');
                                            ii(jj)=i;
                                            Pi(i)=0;
                                            Pi=Pi/sum(Pi);
                                        end
                                        idx=(cc-1)*m+1:cc*m;
                                        d(ii)=d(ii)+1;
                                        d(cc+m_0)=m;
                                        I(idx)=ii;
                                        J(idx)=cc+m_0;
                                    end
                                else
                                    %leave as nan
                                end
                            case 3 %regular graph
                                m=floor(degree/2);
                                I=mod(kron(1:n,ones(1,m))+kron(ones(1,n),1:m)-1,n)+1;
                                J=kron(1:n,ones(1,m));
                            case 4
                                % rewiring
                                p_rewire=.05;
                                m=floor(degree/2);
                                M=n*m;
                                I=mod(kron(1:n,ones(1,m))+kron(ones(1,n),1:m)-1,n)+1;
                                J=kron(1:n,ones(1,m));
                                
                                idx=randperm(M,round(M*p_rewire));%  original chance of dropping is M*p_rewire/(n-1)
                                while numel(idx)>0
                                    delta=randi(n-1,1,numel(idx));
                                    new_connection=mod(I(idx)-1+delta,n)+1;
                                    not_same=new_connection~=J(idx);
                                    I(idx(not_same))=new_connection(not_same);
                                    idx=idx(~not_same);
                                end
                            case 6%regular with centroid based preferential detachment
                                p_drop=1;
                                k=ks(k_ii);
                                m=floor(degree/2);
                                I=mod(kron(1:n,ones(1,m))+kron(ones(1,n),1:m)-1,n)+1;
                                J=kron(1:n,ones(1,m));
                                C=randperm(n,k);
                                [~,CI]=min(abs(bsxfun(@minus,C(:),I(:)')));
                                [~,CJ]=min(abs(bsxfun(@minus,C(:),J(:)')));
                                candidate_for_drop=find(CI~=CJ);
                                pp=randperm(numel(candidate_for_drop),round(numel(candidate_for_drop)*p_drop));
                                idx=candidate_for_drop(pp);
                                I(idx)=[];
                                J(idx)=[];
                                
                        end
                        G=sparse([I,J],[J,I],1,n,n);
                        d=sum(G);
                        d12=sqrt(1./d);
                        nL=sparse([I,J,1:n],[J,I,1:n],[repmat(-d12(I).*d12(J),1,2),ones(1,n)],n,n);
                    end
                    dbar{graph_ii}(p_ii,monte_ii,k_ii)=mean(d);
                    
                    for method_ii=1:numel(info_funs)
                        info{graph_ii,method_ii}(p_ii,monte_ii,k_ii)=info_funs{method_ii}(nL);
                    end
                    num_edges=full(sum(d)/2);
                    phat=num_edges/(n*(n-1)/2);
                    if num_edges>=1
                        Phat=phat*(1-eye(n));
                        A_P=(full(G)-Phat)/sqrt(phat*(1-phat)*(n-1));
                        A_P=(A_P+A_P')/2;
                        eig1{graph_ii,1}(p_ii,monte_ii,k_ii)=eigs(A_P,1,'LA');
                        B=full(G)-d'*d/sum(d);
                        [Us,~]=eigs(B,1,'LA');%   compute largest eigenvector
                        s=Us>0;
                        eig1{graph_ii,2}(p_ii,monte_ii,k_ii)=s'*B*s/(2*sum(d));
                    end
                end
            end
        end
    end
    
    unique_edge_counts=unique(cell2mat(cellfun(@(X) unique(floor(X(:)*n/2)),dbar,'uni',0)));
    if any (unique_edge_counts>n*(n-1)/2)
        error('more edges than possible');
    end
    save('../results/ER_edge_count_measure_vals_eig_degrees','unique_edge_counts','eig1','info','info_funs','dbar');
else
    n=100;
    load('../results/ER_edge_count_measure_vals_eig_degrees','unique_edge_counts','eig1','info','info_funs','dbar');
end



%%
measure_name={'Euclid','Cosine','HSIC','CKA','Chernoff','Quantum Hellinger','Bures-based','Sub-Bures','Bartlett','Lawley','Eig1','Mod'};
measure_short_name={'Euclidean','Cosine','HSIC','CKA','Chernoff','QH','Bures','Sub-Bures','Bartlett','Lawley','Bickel and Sarkar','Newman'};
measure_file_name={'eucl','cosine','hsic','cka','chernoff','qh','bures','subbures','bartlett','lawley','bickel','newman'};


linestyles={'ok','dr','b-','sm','wow','.m-','.g-'};
markersizes={9,   7,   9,  5 , 4, 4, 4};
ngraphs=numel(dbar);
%Colorblind safe from Bang Wang, Nature Methods, 2011
rgb_colors=[0 0 0
    230 159 0
    86 180 233
    0 158 115
    204 121 167
    213 94 0
    0 114 178
    240 228 66]/255;

%%
for jjj=1:2
    figure(1100+jjj),clf
    hs=zeros(ngraphs,1);
    y=eig1{6,jjj}(:,:);
    h=plot(dbar{6}(:,:),y,'k.','markersize',11);
    set(h,'color',rgb_colors(5,:))
    hs(6)=h(1);
    hold all
    
    for graph_ii=1:4
        y=eig1{graph_ii,jjj}(:,:);
        h=plot(dbar{graph_ii}(:,:),y,...
            linestyles{graph_ii},'markersize',markersizes{graph_ii},'linewidth',1.5);
        set(h,'color',rgb_colors(graph_ii,:))
        if graph_ii==3
            set(h,'linewidth',3)
        end
        hold all
        hs(graph_ii)=h(1);
    end
    set(gca,'yscale','linear','xscale','log')
    set(gca,'xtick',[.1 1 10 100]','fontsize',15)
    xlabel('Average degree (n=100, log-scale)')
    if jjj==1
        ylabel('Largest eigenvalue (Bickel & Sarkar)');
    else
        ylabel('Modularity of cut (Newman)');
    end
    
    set(gca,'xlim',[1 110]);
    ylims=get(gca,'ylim');
    set(gca,'ylim',[0 ylims(2)+.9*diff(ylims)])
    legend(hs([1 2 3 4 6 ]),{'E. & R.','B. & A.','regular','W. & S.','clustered regular'},'Location','Northwest')
    set(gca,'fontsize',14)
    
    set(gcf,'position',get(gcf,'position').*[1 1 0 0]+1.5*[0 0 240 200])
    set(gcf,'paperpositionmode','auto');
    saveas(gcf,['../results/Figure_11_',measure_file_name{end-2+jjj},'_graph_a.eps'],'epsc')
end

%%

for method_ii=[7 10]
    figure(1100+method_ii),clf
    hs=zeros(ngraphs,1);
    phat=dbar{6}(:,:)/(n-1);
    y=info{6,method_ii}(:,:);
    h=plot(dbar{6}(:,:),y,'k.','markersize',11);
    set(h,'color',rgb_colors(5,:))
    hs(6)=h(1);
    hold all
    
    for graph_ii=1:4
        phat=dbar{graph_ii}(:,:)/(n-1);
        y=info{graph_ii,method_ii}(:,:);
        h=plot(dbar{graph_ii}(:,:),y,...
            linestyles{graph_ii},'markersize',markersizes{graph_ii},'linewidth',1.5);
        set(h,'color',rgb_colors(graph_ii,:))
        if graph_ii==3
            set(h,'linewidth',3)
        end
        
        hold all
        hs(graph_ii)=h(1);
    end
    set(gca,'yscale','linear','xscale','log')
    xlabel('Average degree (n=100, log-scale)')
    if method_ii>=9
        ylabel(sprintf('%s'' statistic',measure_name{method_ii}))
    else
        ylabel(sprintf('%s informativeness',measure_name{method_ii}))
    end
    set(gca,'xlim',[1 110]);
    legend(hs([1 2 3 4 6 ]),{'E. & R.','B. & A.','regular','W. & S.','clustered regular'},'Location','Northeast')
    set(gcf,'position',get(gcf,'position').*[1 1 0 0]+1.5*[0 0 240 200])
    set(gca,'fontsize',14)
    set(gcf,'paperpositionmode','auto')
    saveas(gcf,['../results/Figure_11_',measure_file_name{method_ii},'_graph_a.eps'],'epsc')
end



%% test statistic
if exist('../results/regular_graph_thresh.mat','file')
    load('../results/regular_graph_thresh.mat','regular_graph_thresh')
else
    regular_graph_thresh=zeros(numel(unique_edge_counts),numel(info_funs)+2);
    for ii=1:numel(unique_edge_counts)
        vals=regular_graph_info(unique_edge_counts(ii),n,[info_funs,'eig1','mod']);
        regular_graph_thresh(ii,:)=vals';
    end
    save('../results/regular_graph_thresh.mat','regular_graph_thresh')
end

%%

names={'E. & R.','B. & A.','regular','W. & S.','','clustered regular','clustered cycle'};

M1=zeros(6,numel(info_funs)+2);
row=0;
    
for graph_idx=[1 2 4 6]
    graph_ii=graph_idx;
    subset_idx=(1:numel(dbar{graph_ii}))';
    x=floor(dbar{graph_ii}(subset_idx)*n/2);
    idx=x>0  & x< n*(n-1)/2;
    x=x(idx);
    [~,edge_count_index]=max(bsxfun(@eq,x,unique_edge_counts'),[],2);
    row=row+1;
    for method_ii=1:numel(info_funs)+2
        col=method_ii;               
        if method_ii<=numel(info_funs)
            y=info{graph_ii,method_ii}(subset_idx(idx));
        else
            y=eig1{graph_ii,method_ii-numel(info_funs)}(subset_idx(idx));
        end
        thresh=regular_graph_thresh(edge_count_index,method_ii);
        power=mean(y>thresh );
        M1(row,col)=power;
    end
end


names={'E. \& R.','B. \& A.','regular','W. \& S.','','clustered regular'};
graph_subset=[1 2 4 6];

C=numel(graph_subset);
S=sprintf('\\begin{tabular}{%s}\n',repmat('l ',1,C+1));
S=cat(2,S,sprintf('\\hline\n'));
fprintf('%s\n%s\n',repmat('-',100));
for row=1:2
    str=sprintf('%20s &','');
    for col=1:C
        graph_ii=graph_subset(col);
        x=dbar{graph_ii}(:);
        if row==1
            a_str=sprintf('%s',names{graph_ii});
        else
            a_str=sprintf('%i',numel(x));
        end
        str=cat(2,str,sprintf('%20s &',a_str));
    end
    fprintf('%s\n',strrep(str(1:end-1),'&','|'));
    S=cat(2,S,sprintf('%s\\\\\n',str(1:end-1)));
end
S=cat(2,S,sprintf('\\hline\n'));
fprintf('%s\n',repmat('-',1,100));

reorder=[1 8 2:7 9:12]; 
column_signs=[-1 -1 -1 1];
for row=1:numel(measure_short_name)
    str=sprintf('%20s &',measure_short_name{reorder(row)});
    for col=1:C
        val1=M1(col,reorder(row));
        if val1==round(val1)
        a_str=sprintf('%i',val1);
        else            
        a_str=sprintf('%.3f',val1);
        end
        if column_signs(col)*val1==max(column_signs(col)*M1(col,:))
        a_str=['\textbf{',a_str,'}'];
        end        
        str=cat(2,str,sprintf('%20s &',a_str));
    end
    fprintf('%s\n',strrep(str(1:end-1),'&','|'));
    str=strrep(str,'%','\%');
    S=cat(2,S,sprintf('%s\\\\\n',str(1:end-1)));
    
end
S=cat(2,S,sprintf('\\hline\n'));
fprintf('%s\n',repmat('-',1,100));
S=cat(2,S,sprintf('\\end{tabular}'));
