function dist = matrix_info_quantum_hellinger_embed_general(Z )
%assumes Z is d by n
[m,n]=size(Z);
[U,S,~]=svd(full(Z'),'econ');
s=diag(S);
sum_K12=U*(s.*sum(U)');
diag_K12=sum(bsxfun(@times,U,sqrt(s)').^2,2);
tr_11K12=sum(sum_K12);
tr_HK12=sum(diag_K12-sum_K12/n);

dist=1-1/n*sqrt(tr_11K12^2/n+n/(n-1)*tr_HK12^2);
end

