function dist = matrix_info_hsic(K )
    n=size(K,1);
    K=K/trace(K)*n;
    kbar=mean(K);
    KH=bsxfun(@minus,K,kbar);
    HKH=bsxfun(@minus,KH,kbar')+mean(kbar);
    HKH_fro=sqrt(sum(HKH(:).^2));
    kbar=mean(K(:));
    dist=sqrt(max(0,HKH_fro^2/n^2-(1-kbar)^2/(n-1)));
