function [dist,a,off_ele] = matrix_info_fro(rho )
n=size(rho,1);
if n>1
rho=rho/trace(rho)*n;%trace of n
trK2=mean(rho(:).^2);
kbar=mean(rho(:));
dist=sqrt(max(0,trK2-1/(n-1)*(n*kbar^2-2*kbar+1)));
a=kbar;
off_ele=a-(1-a)/(n-1);
else
    dist=0;
    a=1;
    off_ele=1;
end

end

