function [dist,a] = matrix_info_chernoff(K)
n=size(K,1);
K=K/trace(K)*n;
[U,E]=eig(full(K+K')/2);
lambda=diag(E);
lambda=lambda.*(lambda>0);%ensure psd

%tr_KsJ=@(s) sum(sum(U*diag(K_eig.^s)*U'));
%tr_KsH=@(s) trace(U*diag(K_eig.^s)*U'*(eye(n)-1/n));

ubar2=sum(U).^2;

tr_KsJ=@(s) ubar2*(lambda.^s);%n 
tr_KsH=@(s) sum(lambda.^s)-tr_KsJ(s)/n;
Qfunc=@(s,a) a.^(1-s)/n^(s+1)*tr_KsJ(s)+((1-a)/(n-1))^(1-s)/n^s*tr_KsH(s);

e_s=@(s) (tr_KsH(s)/tr_KsJ(s)*n/(n-1)^(1-s))^(1/s);
a_s=@(s) 1/(1+e_s(s));

[s_opt,Q]=fminbnd(@(s) Qfunc(s,a_s(s)),0,1,optimset('TolX',1e-6,'Display','off'));
% tic
% [s_opt,Q]=fmincon(@(s) Qfunc(s,a_s(s)),.5,[],[],[],[],0,1);
% fprintf('%f %f %fs\n',s_opt,Q,toc);
a=a_s(s_opt);
dist=1-Q;