function [rez,T,dist,a,off_ele] = matrix_info_bartlett(rho,do_dist)
n=size(rho,1);
if n>1
rho=rho/trace(rho)*n;%trace of n
kbar=mean(rho(:));
rbar=(kbar*n-1)/(n-1);
y=(rho-rbar).*(1-eye(n));
ybark=sum(y,2)/(n-1);
ybar=mean(ybark);%=(kbar*n-1)/(n-1)
lambda=1-rbar;
if lambda>0
%T=0.5/lambda^2*(sum((y(:)-ybar).^2)-(2*(n-1)^2/n)*sum((ybar-ybark).^2));
T=0.5/lambda^2*((rho(:)'*rho(:)-n^2/(n-1)*(n*kbar^2-2*kbar+1))...
    -2*n*norm(mean(rho)-kbar)^2);
else
    T=0;
end
a=kbar;
dist=T*lambda^2;
off_ele=a-(1-a)/(n-1);
else
    dist=0;
    a=1;
    off_ele=1;
end

if nargin==2 && do_dist==1
    rez=dist;
else
    rez=T;
end




end

