function [inf_dist,a,E] = jensen_shannon_info_fminbnd(rho )
[m,n]=size(rho);
if n==m % %assume rho is correlation matrix then normalize it
rho=rho/trace(rho);
else % assume  dimensions by samples embedding
  fprintf('Embedding not implemented')  
end
H=@(x) -x(:)'*log2(x(:)+1*(x(:)==0));
s_k=svd(full(rho));
H_k=H(s_k);

J=@(a) a/n+(1-a)/(n-1)*(eye(n)-1/n);%density matrix
H_j=@(a) H([a (1-a)/(n-1)*ones(1,n-1)]);
s_kj=@(a) svd((rho+J(a))/2);
[a,inf_dist]=fminbnd(@(a) H(s_kj(a))-(H_j(a)+H_k)/2,0,1);
if nargout>=3
E=(1-a)/(n-1)*(eye(n)-1/n)+a/n;
end


end

