function [dist,a,off_ele] = bures_super_lb_matrix_info_embed(Z )
%assumes Z is d by n
Z=bsxfun(@rdivide,Z,sqrt(sum(Z.^2,1)));
[m,n]=size(Z);
if n>1
if m<n
Kvec=Z*Z';
else
    Kvec=Z'*Z;
end
mu=mean(Z,2);
trK2=1/n^2*sum(Kvec(:).^2);
kbar=norm(mu)^2;




    G_a=@(a) 1/(n-1)*(1-kbar+a*(n*kbar-1))+sqrt(max(0,(1-trK2)/(n-1)*(n-2-n*a.^2+2*a)));
    
    
    bb=((n*kbar-1)/(n-1))^2;
    cc=(1-trK2)/(n-1);
    if trK2==1 && kbar==1/n
        G_a=@(a) 1/(n-1)*(1-kbar);    %constant value
    end
    a=(cc*n+bb+sqrt((cc*n+bb)^2-(cc*n^2+bb*n)*(cc+bb*(2-n))))/(cc*n^2+bb*n);
    a2=(cc*n+bb-sqrt((cc*n+bb)^2-(cc*n^2+bb*n)*(cc+bb*(2-n))))/(cc*n^2+bb*n);
    as=[a a2];    
    as=min(1,max(0,as));
    [superFidelity,max_a_idx]=max([G_a(as(1)),G_a(as(2))]);
    bcoef=min(1,sqrt(superFidelity));
    a=as(max_a_idx);
    dist=1-bcoef;
    off_ele=a-(1-a)/(n-1);
else
    dist=0;
    a=1;
    off_ele=1;
end
end

