function [Z,Zs,stats]=denoiseInfo(K,max_rank,desired_rank,rho)
[m,n]=size(K);
if m==n && norm((K-K')/norm(K,'fro'),'fro')<1e-6 % assume similarity matrix
    %find intial embedding
    tol=norm(K,'fro')*eps;
    if max_rank>=n
        [V,E]=eig(K);
    else
        [V,E]=eigs(K,max_rank,'la');
    end
    p=diag(E);
    [p,idx]=sort(p,'descend');
    V=V(:,idx);
    V=V(:,p>tol);
    p=p(p>tol);
    Z0=real(diag(sqrt(p))*V');
    Z0=Z0/norm(Z0,'fro')*sqrt(n);
else
    Z0=K;
end

if nargin<4
    rho=1;
end
lambda=1;
Z=Z0;
Ztarget=Z0;
iter_count=1;
max_iter=100;
Zs=cell(max_iter,1);
stats=zeros(max_iter,3);
while iter_count<=max_iter
    Zlast=Z;
    %warm restarts
    [Z,Ztarget] = denoiseInfoADMM(Z,Ztarget,lambda,rho);
    
    pt_norms=sqrt(sum(Z.^2,1));
    if any(pt_norms<1-1e-3)
        %fprintf('Interior to oblique manifold\n');
        Z=Zlast;
        break;
    end
    rownorm=sqrt(sum(Z.^2,2));      %check norm of each row
    % remove those that contribute less than 1% of max
    keep_index=rownorm>=min(max(rownorm)/100,max(rownorm));
    Z=Z(keep_index,:);
    Ztarget=Ztarget(keep_index,:);
    Z=Z/norm(Z,'fro')*sqrt(n);
    Zs{iter_count}=Z';
    Ztarget=Ztarget/norm(Ztarget,'fro')*sqrt(n);
    
    stats(iter_count,1)=lambda;
    stats(iter_count,2)=size(Z,1);
    stats(iter_count,3)=bures_metric(Z'*Z,Z0'*Z0);
    new_size=sum(keep_index);
    if new_size<=desired_rank
        break;
    end
    lambda=lambda*1.25;
    iter_count=iter_count+1;
    
end
Z=Z/norm(Z,'fro')*sqrt(n);
Z=Z';
end



