function [grouped_approx,grouped_comp,grouped_waveforms] = mptkDecompose_gabor(signal,Maxlength,Natoms)
%Approximates a signal using the multiple passes of matching pursuit
%signal - (signal vector) segment of original signal to approximate
t=tic;
if ismac()
    setenv('MPTK_CONFIG_FILENAME','/usr/local/mptk/path.xml')
    addpath('/usr/local/mptk/matlab')
else
    %need to set these for PC too!
end

Lengths=2*round(.5*logspace(log10(5),log10(Maxlength),nextpow2(Maxlength/5)));
dict=[];
a_struct=struct('blockOffset','0','fftSize','128','type','gabor','windowLen','512','windowShift','32','windowopt','0','windowtype','gauss');
dict.block={a_struct};
dict.block=repmat(dict.block(1),numel(Lengths),1);
for ii=1:numel(Lengths)
    dict.block{ii}.windowLen=sprintf('%i',Lengths(ii));
    dict.block{ii}.fftSize=sprintf('%i',2^nextpow2(Lengths(ii)));
    dict.block{ii}.windowShift=sprintf('%i',floor(Lengths(ii)/4));
end
if Natoms==0
    Natoms=numel(signal)/4;
end
[book,Rf,decay] = mpdecomp(signal,1,dict,Natoms);%MPTK API call
Ff1=signal-Rf;
run_time=toc(t);
fprintf('Atoms %i, rmse %g, run time %gs\n',book.numAtoms,norm(Rf),run_time);
tic

[~,grouped_waveforms] = mptkGaborBookToAtomsWaves(book,dict,0);
[grouped_approx,grouped_comp,Ff2] = mptkGaborBookToComponents(book,dict);
wave_len=cell2mat(cellfun(@(x) size(x,1)*ones(size(x,2),1),grouped_waveforms(:),'uni',0));
wave_group_len=cellfun(@(x) size(x,1),grouped_waveforms(:));
[~,idx]=sort(wave_len,'descend');
[~,group_idx]=sort(wave_group_len,'descend');
grouped_waveforms=grouped_waveforms(group_idx);
grouped_approx=grouped_approx(group_idx);
grouped_comp=grouped_comp(idx);
run_time=toc(t);
fprintf('New  rmse %g, run time %gs\n',norm(signal-Ff2),run_time);

non_gabor_snr=norm(Ff2-Ff1)/norm(signal);
if non_gabor_snr>1e-1
    fprintf('Computation of approximation from waveforms differs from full %.2f dB\n',-20*log10(non_gabor_snr));
end

end

