function [a,r,c] = inputaug(dummy)
%INPUTAUG(dummy)  Solicita entrada de uma matriz pelo usurio.
%   [a,r,c]=INPUTAUG(dummy) solicita a entrada de uma matriz pelo teclado,
%   no formato Matlab apropriado.  Apenas matrizes no-nulas, no vazias e
%   aumentadas so aceitas.  O argumento 'dummy' no  utilizado pela funo
%   e apenas garante a sintaxe.
%
%   INPUTAUG retorna os seguintes valores:
%
%   a		matriz aumentada
%   r		nmero de linhas (rows) da matriz aumentada
%   c		nmero de colunas (columns) da matriz aumentada (sempre r+1)
%
%   Veja tambm GELIM, PIVOT.
%
%     por Marcos Portnoi, 06/2000  ltima alterao 25/06/2000 13:17
%

r=0; %numero de linhas da matriz
c=0; %numero de colunas da matriz
a=1; %matriz aumentada

while (isempty(a)) | (c<r+1)
   a=input('Entre com a matriz aumentada no formato Matlab apropriado\n:  ')
   [r,c]=size(a);
   if isempty(a)
      disp('Erro:  matriz nula ou vazia.')
   end
   if c<r+1  %nmero de colunas  igual a nmero de linhas + 1?
      disp('Erro:  matriz nao aumentada.')
   end
end
%return