%GELIM  Triangularizao de matrizes por eliminao gaussiana.
%
%   Este programa calcula a matriz triangularizada a partir da matriz aumentada,
%   usando eliminao gaussiana.
%   Fornece tambm os valores das variveis de sistema representados
%   na matriz aumentada.
%
%   Em caso de sistema indefinido ou impossvel, a matriz triangularizada  mostrada
%   e as variveis do sistema sero representadas por infinitos ou NaN's (0=0).
%
%   Sadas:  a (matriz triangularizada)
%            x (vetor das variveis do sistema)
%
%   Veja tambm PIVOT, INPUTAUG.
%
%     por Marcos Portnoi, 06/2000  ltima alterao 25/06/2000 13:15
%
%

clear all
warning off  %desabilita msg warning em caso de diviso por zero em sistemas impossveis ou indeterminados
dummy=0;

disp(' ')
disp(' ')
disp('Este programa calcula a matriz triangularizada a partir da matriz aumentada,')
disp('usando eliminao gaussiana.')
disp('Fornece tambm os valores das variveis de sistema representados')
disp('na matriz aumentada.')
disp(' ')
disp('Em caso de um sistema indefinido, a matriz triangularizada ser calculada')
disp('e os valores das variveis do sistema sero representadas por infinitos.')
disp(' ')
[a,r,c]=inputaug(dummy);  %nenhum argumento  transmitido  funo

for i=2:r  %primeiro loop, controla numero de eliminacoes = nmero de linhas-1
   [a,f]=pivot(a,i,r,c);
   if f==0  %se flag f = 1, piv  nulo; passar para coluna seguinte (toda a coluna abaixo j  nula)
      for j=i:r  %da linha atual at a ltima
         %cada eliminao deve ser feita da linha corrente at a ltima
         m=a(j,i-1)/a(i-1,i-1);  %multiplicador
         a(j,i-1)=0;  %faz elemento igual a zero (eliminacao gaussiana), evitando aproximacoes pela diviso
         
         for k=i:c  %do elemento linha at o ltimo elemento (coluna) da linha atual
            a(j,k)=a(j,k)-m*a(i-1,k);  %formula de Gauss
         end  %next k
      end  %next j
   end  %endif
end  %next i


%Retrosubstituio procedural

x(r)=a(r,c)/a(r,c-1);  %primeira substituicao
for i=r-1:-1:1  %linha da retrosubstituicao
   x(i)=a(i,c);
   for j=c-1:-1:i+1  %coluna da retrosubstituicao
      x(i)=x(i)-a(i,j)*x(j);
   end
   x(i)=x(i)/a(i,i);
end

%Mostrar resultados

disp(' ')
disp('Matriz triangularizada:')
a
disp('Valores das variaveis do sistema:')
x
warning backtrace  %reabilita msg warning
