function [a,f] = pivot(a,i,r,c)
%PIVOT	Funo de pivoteamento de matrizes
%   [a,f] = PIVOT(a,i,r,c) realiza o pivoteamento de uma matriz para uso
%   da eliminao gaussiana, evitando pivs nulos e diminuindo
%   erros de arredondamento.  PIVOT verifica o elemento da coluna piv
%   com maior valor absoluto, desconsiderando as linhas anteriores,
%   e troca a linha corrente pela linha com este elemento de maior valor
%   absoluto encontrado.
%   A eliminao gaussiana prev matrizes aumentadas, mas a funo PIVOT
%   funciona com matrizes de qualquer dimenso.
%
%   Os argumentos a serem passados so:
%
%   a		matriz a ser pivoteada
%   i		linha corrente ou atual, abaixo da qual os elementos sero testados
%   r		nmero de linhas (rows) da matriz
%   c		nmero de colunas (columns) da matriz
%
%   A funo retorna:
%
%   a		matriz pivoteada
%   f		flag (1 = piv nulo, 0 = piv no nulo)
%
%   Veja tambm GELIM, INPUTAUG.
%
%     por Marcos Portnoi, 06/2000  ltima alterao 25/06/2000 17:01
%

f=0;  %flag = 1 para piv nulo

%Processo abaixo usa poder de manipulao de matrizes do Matlab
%p=i-1;
%[p,p]=max(abs(a(i-1:r,i-1)));  %acha ndice da linha com maior valor absoluto na coluna atual para baixo
%p=p+(i-1)-1;  %ajusta valor de p, que antes era relativo  linha atual
%Troca linha p por linha i-1
%a([i-1 p],:)=a([p i-1],:);

%Mtodo abaixo  completamente procedural
p=i-1;
for j=i:r  %testar qual elemento na coluna atual tem o maior valor absoluto
   if abs(a(i-1,i-1))<abs(a(j,i-1))  %da linha atual at a ltima
      p=j;  %se modulo elemento testado for maior, faa sua linha a piv
   end
end
%variavel p contm a linha com elemento de maior valor absoluto, ou linha do elemento pivot
%inicia processo de troca de linhas, elemento por elemento
for j=1:c
   aux=a(i-1,j);
   a(i-1,j)=a(p,j);
   a(p,j)=aux;
end

if a(i-1,i-1)==0  %se piv for nulo, setar flag
   f=1;
end
%return