/*********************************************************/
#include	<std.h>
#include	<rt11.h>
#include	<mmmhdr.h>

/*********************************************************/
#define ESC	033		/* escape char. */

/*********************************************************/
/****** external functions from genlib */
int	lsttab(),srchtab(),sorttab();
TEXTPTR	getstr();

/*********************************************************/
/****** external functions from mmmed */
int	dispimg();
int	curup(),curdown(),curright(),curleft();
int	getpic(),plane(),defseg(),lclip();
int	rclip(),tclip(),bclip(),revcol(),reinit();
int	moveseg(),paste(),select(),nscale(),lstcoms();
int	istore(),iread(),prtimg(),traverse(),setcur();
int	fill(),xscale(),yscale();
int	delete(),undelete(),autosel();

/*********************************************************/
/****** external functions from supprt */
int	info();

/*********************************************************/
/****** external functions from mmmcli */
int	quit(),illcom(),ambcom(),dump();


/*********************************************************/
/* command table */
#define	MAXCOM  28

static	TEXTPTR	comtab[]
	{ "QUIT","GETPIC","PLANE","DEFSEG","LCLIP",
	"RCLIP","TCLIP","BCLIP","REVERS","REINIT", 
	"MOVE","PASTE","SELECT","NSCALE","?",
	"STORE","READ","PRTIMG","TRAVERSE","SETCUR",
	"INFO","FILL","XSCALE","YSCALE","DUMP",
	"DELETE","UNDELETE","AUTOSEL"};

/* table of functions that handle corresponding commands */
/* first four entries are for cursor movement */
/* last two entries are for illegal and ambiguous commands */
static	PFI	functab[] = 
	{&curup,&curdown,&curright,&curleft,
	&quit,&getpic,&plane,&defseg,&lclip,
	&rclip,&tclip,&bclip,&revcol,&reinit,
	&moveseg,&paste,&select,&nscale,&lstcoms,
	&istore,&iread,&prtimg,&traverse,&setcur,
	&info,&fill,&xscale,&yscale,&dump,
	&delete,&undelete,&autosel,
	&illcom,&ambcom
	 };

/*********************************************************/
/* this is the command interpreter for the image editor */

static	int	comquit = 0;	/* QUIT command index in table */
BYTES *jsw =	044;		/* RT11 job status word pointer */

/* external globals */
TEXT	errtyp[]; 	/* err mess for wrong type of page (from mmmcli) */
TEXT	linbuf[] ;	/* temp buff. from mmmcli */
TREEPTR	top;		/* pointer to top node of current page(from mmmcli) */
TREEPTR	present;	/* pointer to current node in current page */ 
			/* (from edimg) */

/*********************************************************/
/* command interp. for image editor. Sorts tables ( to
   give pretty command listing ), and then calls command
   handler for each user command */

edimage()
{
int	command = 10;

sorttab(comtab,functab+4,MAXCOM);
comquit = 4 + srchtab(comtab,MAXCOM,"QUIT");

if ( (top) && ( (top->alg < 0) || ( top->alg > 2) ) ) {
	putstr(STDERR,errtyp,NULL);
	return;
	}		/* probably a text type node */

putstr(STDOUT,"welcome to the image editor...\n",NULL);
dispimg(top);		/* show what we got */

do	{
	if  (command >= 4 ) putstr(STDOUT,">",NULL); /* no prompt if prev.*/
					/* comm. was a cursor move */
	INDCALL( functab[command = getcom()] );
	} 
while (command != comquit );

}

/*********************************************************/
/* gets next command; returns index of command in command table */
/* The arrow keys are commands 0..3, the
rest of the commands in the table are numbered 4 onwards */

int	getcom()
{
TINY	ch;
int	n;

*jsw |= 010000;				/* set char. mode input */
while ( !(ch = emt(0340,0) )  ) ;	/* get a char. repeat if NULL */
if ( ch ==  ESC){			/* if arrow key */
	while ( !(ch = emt(0340,0) )  ) ; /* skip next char ( '[' ) */
	while ( !(ch = emt(0340,0) )  ) ;
	*jsw &= ~010000;		/* reset to line mode input */
	if ( ( (n = ch-'A') >= 0) && (n <= 3)  ) 
		return (n); 		/* true arrow key */
	return ( MAXCOM + 4 );		/* illegal command */
	}
else {
	emt(0341,ch);			/* echo this char. */ 
	*linbuf = ch;
	*jsw &= ~010000;		/* reset to line mode input */
	getstr("",linbuf+1);		/* get rest of string */
	return( srchtab(comtab,MAXCOM,linbuf) + 4 ); /* search comtab */ 
	}	/* of else */

} 	/* of getcom */


/*********************************************************/
/* list commands */
lstcoms()
{
lsttab(comtab,MAXCOM);
}
                                                                                                                                                                                                                                                