	SUBROUTINE FRSTPT(X,Y)
	COMMON /PLOT/ XA,XB,YA,YB,XC,XD,YC,YD
	INTEGER*2 I,J
	I=XA+(XB-XA)/(XD-XC)*(X-XC)
	J=YA+(YB-YA)/(YD-YC)*(Y-YC)
	CALL MOVE(I,J)
	RETURN
	END
	SUBROUTINE VECTOR(X,Y)
	COMMON /PLOT/ XA,XB,YA,YB,XC,XD,YC,YD
	INTEGER*2 I,J
	I=XA+(XB-XA)/(XD-XC)*(X-XC)
	J=YA+(YB-YA)/(YD-YC)*(Y-YC)
	CALL DRAW(I,J)
	RETURN
	END
	FUNCTION ACOS(X)
	X1=1.-X*X
	IF (X1 .GT. 0.) GOTO 100
	ACOS = 90.*1.7453292519943E-2
	GOTO 200
C
100	ACOS = 3.1415926535/2 - ATAN(X/SQRT(X1))
200	RETURN
	END
	SUBROUTINE QCON
C
C THIS SUBROUTINE TRANSFORMS THE POINT (RLAT,RLON),IN DEGREES,
C TO (U,V) ON THE MAP PLANE DEPENDENT UPON THE PROJECTION,IPROJ.
C
	COMMON /SUPMP1/ DTR,ILF,PHIOC,SINR,U2,CONE,EPS,ILTS,
	1 PI,TOVPI,V,CON1,ICROSS,IOUT,POLONG,U,VEPS,CON2,IPROJ,
	2 RLAT,UEPS,VMAX,COSO,IFST,JGR,RLON,UMAX,VMIN,COSR,IGO,OV90,
	3 RTD,UMIN,VOLD,DI,IGOLD,PHIA,SGN,UOLD,V1,DS,IGRID,PHIO,
	4 SINO,U1,V2,DSRDI,IIER
	DATA OLDU,OLDV /0.,0./
C
	TAN(X) = SIN(X)/COS(X)
C
	U = AMOD(RLON+PHIOC,360.)-180.
	GOTO (50,50,130,50,50,50,170,50,50,50,210,220,230),IPROJ
C
50	T1 = U*DTR
	T2 = RLAT*DTR
	SINPH = SIN(T1)
	COSPH = COS(T1)
	SINLA = SIN(T2)
	COSLA = SQRT(CON1-SINLA*SINLA)
	TCOS = COSLA*COSPH
	COSA = SINLA*SINO+TCOS*COSO/CON1
	SINA = SQRT(CON1-COSA*COSA)
	OVSINA = 1./SINA
	SINB = COSLA*SINPH*OVSINA
	COSB = (SINLA*COSO-TCOS*SINO)*OVSINA
C
C PERFORM TRANSFORMATION APPROPRIATE TO THE PROJECTION
C
	GOTO (110,120,130,140,150,160,170,180,190,200),IPROJ
C
C STEREOGRAPHIC [ 1 ]
C
110	R = (1.-COSA)*OVSINA
	GOTO 300
C
C ORTHOGRAPHIC [ 2 ]
C
120	R = SINA
	IF (COSA) 320,320,300
C
C LAMBERT CONFORMAL CONIC [3]
C
130	UDIF = ABS(U-OLDU)
	OLDU = U
	CHI = 90.-SGN*RLAT
	IF (CHI .GE. CON2) GOTO 320
	R = TAN(.5*DTR*CHI)**CONE
	U = U*CONE*DTR
	V = -R*SGN*COS(U)
	U = R*SIN(U)
	GOTO 310
C
C LAMBERT EQUAL AREA [ 4 ]
C
140	IF (ABS(COSA+1.) .LT. 1.E-6) GOTO 320
	R = (1.+COSA)*OVSINA
	R = 2./SQRT(1.+R*R)
	GOTO 300
C
C GNOMONIC [ 5 ]
C
150	IF (COSA .LE. 0.) GOTO 320
	R = SINA/COSA
	GOTO 300
C
C AZIMUTHAL EQUIDIDSANT [ 6 ]
C
160	IF (ABS(COSA+1.) .LT. 1.E-6) GOTO 320
	R = ACOS(COSA)
	GOTO 300
C
C DUMMY -- ERROR
C
170	IIER = 33
C 33 SUPMAP-ATTEMPT TO USE NON-EXISTANT PROJECTION
	GOTO 320
C
C CYLINDRICAL EQUIDISTANT,ARBITRARY POLE AND ORIENTATION.
C
180	IF (ABS(1.-COSA*COSA) .LT. 1.E-5) GOTO 320
	U = ATAN2(SINB*COSR+COSB*SINR,SINB*SINR-COSB*COSR)*RTD
	V = 90.-ACOS(COSA)*RTD
	GOTO 305
C
C MERCATOR,ARBITRARY POLE AND ORIENTATION.
C
190	IF (ABS(1.-COSA*COSA) .LT. 1.E-5) GOTO 320
	U = ATAN2(SINB*COSR+COSB*SINR,SINB*SINR-COSB*COSR)
	V = ALOG((1.+COSA)*OVSINA)
	GOTO 305
C
C MOLLWEIDE,ARBITRARY POLE AND ORIENTATION.
C
200	IF (ABS(1.-COSA*COSA) .LT. 1.E-5) GOTO 320
	U = ATAN2(SINB*COSR+COSB*SINR,SINB*SINR-COSB*COSR)*TOVPI
	V = COSA
	UDIF = ABS(U-OLDU)
	OLDU = U
	U = U*SQRT(1.-V*V)
	GOTO 310
C
C CYLINDRICAL EQUIDISTANT FOR POLAT = ROT = 0. [ 11 ]
C
210	V = RLAT
	GOTO 305
C
C MERCATOR [ 12 ]
C
220	U = U*DTR
	V = ALOG(TAN(.00872664*(RLAT+90.0001)))
	GOTO 305
C
C MOLLWEIDE [ 13 ]
C
230	IF (ABS(RLAT) .EQ. 90.) GOTO 320
	U = U*OV90
	V = SIN(RLAT*DTR)
	UDIF = ABS(U-OLDU)
	OLDU = U
	U = U*SQRT(1.-V*V)
	GOTO 310
C
C TERMINAL PHASE (1,2,4,5,6)
C
300	U = R*(SINB*COSR+COSB*SINR)
	V = R*(COSB*COSR-SINB*SINR)
C
C CHECK FOR CROSSOVER
C
305	UDIF = ABS(U-OLDU)
	OLDU = U
310	VDIF = ABS(V-OLDV)
	OLDV = V
	ICROSS = 0
	IF (UDIF .GT. UEPS .OR. VDIF .GT. VEPS) ICROSS = 1
	RETURN
C
C DISPENSE WITH UNDEFINED POINTS
C
320	U = 1.E12
	ICROSS = 0
	IF (ABS(U-OLDU) .GT. UEPS) ICROSS = 1
	OLDU = U
	RETURN
C
	END
	SUBROUTINE QVEC
C
C THIS SUBROUTINE TRANSFORMS AND PLOTS LINE SEGMENTS
C FOR SUPMAP AND OTHERS
C
C INPUTS (PASSED THROUGH COMMON.)
C
C (RLAT,RLON) NEXT POINT TO BE PLOTTED
C IFST - A FLAG USED TO SIGNAL THE FIRST POINT OF A LINE SEGMENT
C = 0 _ START A NEW LINE
C = 1 _ CONTINUATION OF A LINE
C
C OTHER VARIABLES
C
C (U,V) NEXT POINT TRANSFORMED TO THE VIRTUAL SCREEN BY
C SUPCONQ ICROSS - A FLAG RETURNED BY SUPCONQ FOR CYLINDRICAL
C PROJECTIONS IGO = 0 _ LAST POINT NOT PLOTTED
C = 1 _ LAST POINT WAS PLOTTED.
C (U1,V1),(U2,V2) PARAMETERS PASSED TO SUPTRP.
C
	COMMON /SUPMP1/ DTR,ILF,PHIOC,SINR,U2,CONE,EPS,ILTS,
	1 PI,TOVPI,V,CON1,ICROSS,IOUT,POLONG,U,VEPS,CON2,IPROJ,
	2 RLAT,UEPS,VMAX,COSO,IFST,JGR,RLON,UMAX,VMIN,COSR,IGO,OV90,
	3 RTD,UMIN,VOLD,DI,IGOLD,PHIA,SGN,UOLD,V1,DS,IGRID,PHIO,
	4 SINO,U1,V2,DSRDI,IIER
C
	SQU(X) = (X)*(X)
C
C
C TRANSFORM THE POINT
C
	CALL QCON
C
C HAVE WE FLIPPED TO OTHER SIDE OF FRAME
C
	IF (ICROSS .NE. 0) IGO = 0
C
C ARE WE WITHIN THE FRAME.
C
	IF (U .GT. UMAX .OR. U .LT. UMIN .OR. V .GT. VMAX .OR.
	1 V .LT. VMIN) GOTO 20
	IF (IGO .EQ. 0) GOTO 30
C
C CONTINUE LINE
C CHECK PROXIMITY TO PREVIOUS POINT.
C
5	IF ((SQU(U-UOLD)+SQU(V-VOLD))*DS .LE. DI) RETURN
	CALL VECTOR(U,V)
10	UOLD = U
	VOLD = V
	IGOLD = IGO
	RETURN
C
C THIS POINT LIES OUTSIDE THE FRAME
C
20	IGO = 0
	IF (IFST .NE. 0) GOTO 65
	IF (IGOLD .EQ. 0) GOTO 10
C
C IT WAS INSIDE _ INTERPOLATE TO EDGE OF FRAME
C STATUS OF LAST POINT. IF NOT INSIDE FRAME GO ON
C IF UNINTERPOLATABLE
C
	IF (ICROSS .NE. 0) GOTO 70
	U1 = UOLD
	V1 = VOLD
	U2 = U
	V2 = V
	CALL SUPTRP
C
C CHECK PROXIMITY TO PREVIOUS POINT.
C
	IF ((SQU(U-UOLD)+SQU(V-VOLD))*DS .LE. DI) GOTO 25
	CALL VECTOR(U,V)
25	UOLD = U2
	VOLD = V2
	IGOLD = 0
	RETURN
C
C THIS POINT IS WITHIN THE FRAME
C IS IT THE FIRST POINT OF A LINE
C
30	IF (IFST .NE. 0) GOTO 60
	IF (IGOLD .EQ. 0) GOTO 50
C
C THE PREVIOUS POINT WAS INSIDE THE FRAME ON THE OTHER SIDE.
C START A NEW LINE
C
40	CALL FRSTPT(U,V)
	IGO = 1
	GOTO 10
C
C LAST POINT NOT IN FRAME - THIS ONE IS
C
50	IF (ICROSS .NE. 0) GOTO 40
C
C INTERPOLATE BACK TO EDGE
C
	U1 = U
	V1 = V
	U2 = UOLD
	V2 = VOLD
	CALL SUPTRP
	CALL FRSTPT(U,V)
	IGO = 1
	IGOLD = 1
	UOLD = U
	VOLD = V
	U = U1
	V = V1
	GOTO 5
C
C FIRST POINT ON LINE SEGMENT
C
60	CALL FRSTPT(U,V)
	IGO = 1
65	IFST = 0
	GOTO 10
C
C IGNORE UNDEFINED POINT
C
70	IFST = 1
	GOTO 10
C
	END
	SUBROUTINE SUPTRP
C
C THE INTERPOLATION ROUTINE
C FINDS (U,V) ON THE EDGE OF THE FRAME NEAREST (U1,V1)
C (U1,V1) MUST LIE WITHIN THE FRAME,(U2,V2) WITHOUT.
C
	COMMON /SUPMP1/ DTR,ILF,PHIOC,SINR,U2,CONE,EPS,ILTS,
	1 PI,TOVPI,V,CON1,ICROSS,IOUT,POLONG,U,VEPS,CON2,IPROJ,
	2 RLAT,UEPS,VMAX,COSO,IFST,JGR,RLON,UMAX,VMIN,COSR,IGO,OV90,
	3 RTD,UMIN,VOLD,DI,IGOLD,PHIA,SGN,UOLD,V1,DS,IGRID,PHIO,
	4 SINO,U1,V2,DSRDI,IIER
C
	F(V) = (V-V2)*DU/DV+U2
	G(U) = (U-U2)*DV/DU+V2
C
C
C FIND INDEX TO (U2,V2)
C
C I       I
C 5 I 4 I 6
C I       I
C -------------
C I       I
C 2 I 1 I 3
C I       I
C -------------
C I       I
C 8 I 7 I 9
C I       I
C
	I = 1
	DU = U1-U2
	DV = V1-V2
	A = U2-UMIN
	B = U2-UMAX
	C = V2-VMIN
	D = V2-VMAX
	IF (A) 110,140,120
110	I = I+1
	GOTO 140
C
120	IF (B) 140,140,130
130	I = I+2
140	IF (C) 150,200,160
150	I = I+6
	GOTO 200
C
160	IF (D) 200,200,170
170	I = I+3
C
200	GOTO (900,210,220,230,240,250,260,270,280),I
C
210	U = UMIN
	GOTO 300
C
220	U = UMAX
	GOTO 300
C
230	V = VMAX
	GOTO 350
C
240	IF (F(VMAX)-UMIN) 210,230,230
250	IF (F(VMAX)-UMAX) 230,230,220
260	V = VMIN
	GOTO 350
270	IF (F(VMIN)-UMIN) 210,260,260
280	IF (F(VMIN)-UMAX) 260,260,220
C
C INTERPOLATE
C
300	V = G(U)
	RETURN
C
350	U = F(V)
	RETURN
C
C ERROR EXIT
C
900	U = U2
	V = V2
	RETURN
	END
	BLOCKDATA
C
	COMMON /SUPMP1/ DTR,ILF,PHIOC,SINR,U2,CONE,EPS,ILTS,
	1 PI,TOVPI,V,CON1,ICROSS,IOUT,POLONG,U,VEPS,CON2,IPROJ,
	2 RLAT,UEPS,VMAX,COSO,IFST,JGR,RLON,UMAX,VMIN,COSR,IGO,OV90,
	3 RTD,UMIN,VOLD,DI,IGOLD,PHIA,SGN,UOLD,V1,DS,IGRID,PHIO,
	4 SINO,U1,V2,DSRDI,IIER
C
	DATA CON1 /1.000002/
	DATA CON2 /179.9998/
	DATA DI /16./
	DATA DTR /1.7453292519943E-2/
	DATA EPS /5.E-7/
	DATA OV90/1.11111111111111E-2/
	DATA PI /3.1415926535898/
	DATA RTD /57.295779513082/
	DATA TOVPI /.63661977236758/
	DATA UOLD /0./
	DATA VOLD /0./
C
	END
                                                                                                                                                                          